"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottlingFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _throttling_upload_field = require("./throttling_upload_field");
var _throttling_exceeded_callout = require("./throttling_exceeded_callout");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _throttling_disabled_callout = require("./throttling_disabled_callout");
var _throttling_download_field = require("./throttling_download_field");
var _throttling_latency_field = require("./throttling_latency_field");
var _constants = require("../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThrottlingFields = /*#__PURE__*/(0, _react.memo)(({
  validate,
  onFieldBlur,
  setValue,
  readOnly = false,
  throttling
}) => {
  var _throttling$value, _throttling$value2;
  const maxDownload = _runtime_types.DEFAULT_BANDWIDTH_LIMIT[_runtime_types.BandwidthLimitKey.DOWNLOAD];
  const maxUpload = _runtime_types.DEFAULT_BANDWIDTH_LIMIT[_runtime_types.BandwidthLimitKey.UPLOAD];
  const handleInputChange = (0, _react.useCallback)(({
    value,
    configKey
  }) => {
    setValue({
      ...throttling,
      value: {
        ...throttling.value,
        [configKey]: value
      },
      label: _constants.CUSTOM_LABEL,
      id: _constants.PROFILE_VALUES_ENUM.CUSTOM
    });
  }, [setValue, throttling]);
  const exceedsDownloadLimits = Number((_throttling$value = throttling.value) === null || _throttling$value === void 0 ? void 0 : _throttling$value.download) > maxDownload;
  const exceedsUploadLimits = Number((_throttling$value2 = throttling.value) === null || _throttling$value2 === void 0 ? void 0 : _throttling$value2.upload) > maxUpload;
  const isThrottlingEnabled = throttling.id !== _constants.PROFILE_VALUES_ENUM.NO_THROTTLING;
  const hasExceededLimits = isThrottlingEnabled && (exceedsDownloadLimits || exceedsUploadLimits);
  if (!isThrottlingEnabled || !throttling.value) {
    return /*#__PURE__*/_react.default.createElement(_throttling_disabled_callout.ThrottlingDisabledCallout, null);
  }
  return /*#__PURE__*/_react.default.createElement("div", null, hasExceededLimits && /*#__PURE__*/_react.default.createElement(_throttling_exceeded_callout.ThrottlingExceededCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_throttling_download_field.ThrottlingDownloadField, {
    validate: validate,
    onFieldBlur: onFieldBlur,
    throttling: throttling,
    throttlingValue: throttling.value,
    handleInputChange: val => {
      handleInputChange({
        value: val,
        configKey: 'download'
      });
    },
    readOnly: readOnly
  }), /*#__PURE__*/_react.default.createElement(_throttling_upload_field.ThrottlingUploadField, {
    throttlingValue: throttling.value,
    validate: validate,
    onFieldBlur: onFieldBlur,
    throttling: throttling,
    handleInputChange: val => {
      handleInputChange({
        value: val,
        configKey: 'upload'
      });
    },
    readOnly: readOnly
  }), /*#__PURE__*/_react.default.createElement(_throttling_latency_field.ThrottlingLatencyField, {
    throttlingValue: throttling.value,
    validate: validate,
    onFieldBlur: onFieldBlur,
    throttling: throttling,
    handleInputChange: val => {
      handleInputChange({
        value: val,
        configKey: 'latency'
      });
    },
    readOnly: readOnly
  }));
});
exports.ThrottlingFields = ThrottlingFields;