"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDurationText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
var _status_badge = require("./status_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDurationText = ({
  step
}) => {
  var _step$synthetics$step5, _step$synthetics$step6, _step$synthetics$step7, _step$synthetics$step8;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const stepDuration = (0, _react.useMemo)(() => {
    var _step$synthetics$step, _step$synthetics$step2, _step$synthetics$step3, _step$synthetics$step4;
    const status = (0, _status_badge.parseBadgeStatus)((_step$synthetics$step = (_step$synthetics$step2 = step.synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.status) !== null && _step$synthetics$step !== void 0 ? _step$synthetics$step : '');
    const color = euiTheme.colors[(0, _status_badge.getTextColorForMonitorStatus)(status)];
    if (status === 'skipped') {
      return {
        text: '-',
        color
      };
    }
    return {
      text: (0, _test_time_formats.formatTestDuration)((_step$synthetics$step3 = step.synthetics.step) === null || _step$synthetics$step3 === void 0 ? void 0 : (_step$synthetics$step4 = _step$synthetics$step3.duration) === null || _step$synthetics$step4 === void 0 ? void 0 : _step$synthetics$step4.us),
      color
    };
  }, [euiTheme.colors, (_step$synthetics$step5 = step.synthetics.step) === null || _step$synthetics$step5 === void 0 ? void 0 : (_step$synthetics$step6 = _step$synthetics$step5.duration) === null || _step$synthetics$step6 === void 0 ? void 0 : _step$synthetics$step6.us, (_step$synthetics$step7 = step.synthetics.step) === null || _step$synthetics$step7 === void 0 ? void 0 : _step$synthetics$step7.status]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: stepDuration.color,
    "data-test-subj": `stepDurationText${(_step$synthetics$step8 = step.synthetics.step) === null || _step$synthetics$step8 === void 0 ? void 0 : _step$synthetics$step8.index}`
  }, stepDuration.text);
};
exports.StepDurationText = StepDurationText;