"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JourneyScreenshotPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _screenshot_size = require("../screenshot/screenshot_size");
var _journey_screenshot_dialog = require("../screenshot/journey_screenshot_dialog");
var _screenshot_image = require("../screenshot/screenshot_image");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JourneyScreenshotPreview = ({
  timestamp,
  checkGroup,
  stepName,
  stepNumber,
  imgSrc,
  maxSteps,
  isStepFailed,
  isLoading,
  size,
  unavailableMessage,
  borderRadius
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isImagePopoverOpen, setIsImagePopoverOpen] = (0, _react.useState)(false);
  const [isImageDialogOpen, setIsImageDialogOpen] = (0, _react.useState)(false);

  // Only render the dialog if the image is at least once clicked
  const [isImageEverClick, setIsImageEverClicked] = (0, _react.useState)(false);
  const onMouseEnter = (0, _react.useCallback)(_evt => {
    setIsImagePopoverOpen(true);
  }, [setIsImagePopoverOpen]);
  const onMouseLeave = (0, _react.useCallback)(_evt => {
    setIsImagePopoverOpen(false);
  }, [setIsImagePopoverOpen]);
  const onImgClick = (0, _react.useCallback)(evt => {
    // needed to prevent propagation to the table row click
    evt.stopPropagation();
    setIsImageEverClicked(true);
    setIsImageDialogOpen(true);
    setIsImagePopoverOpen(false);
  }, [setIsImagePopoverOpen]);
  const onDialogClose = (0, _react.useCallback)(() => {
    setIsImageDialogOpen(false);
  }, [setIsImageDialogOpen]);
  const renderScreenshotImage = screenshotSize => /*#__PURE__*/_react.default.createElement(_screenshot_image.ScreenshotImage, {
    label: stepName,
    imgSrc: imgSrc,
    isLoading: isLoading,
    size: screenshotSize,
    unavailableMessage: unavailableMessage,
    borderColor: isStepFailed ? euiTheme.colors.danger : undefined,
    borderRadius: borderRadius,
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave,
    onClick: onImgClick
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isImageEverClick ? /*#__PURE__*/_react.default.createElement(_journey_screenshot_dialog.JourneyScreenshotDialog, {
    checkGroup: checkGroup,
    initialImgSrc: imgSrc,
    initialStepNumber: stepNumber,
    maxSteps: maxSteps,
    isOpen: isImageDialogOpen,
    onClose: onDialogClose,
    timestamp: timestamp
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "leftDown",
    button: renderScreenshotImage(size),
    isOpen: isImagePopoverOpen
  }, renderScreenshotImage(_screenshot_size.POPOVER_SCREENSHOT_SIZE)));
};
exports.JourneyScreenshotPreview = JourneyScreenshotPreview;