"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastRefreshed = LastRefreshed;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _contexts = require("../../../contexts");
var _state = require("../../../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LastRefreshed() {
  const {
    lastRefresh: lastRefreshed
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const [refresh, setRefresh] = (0, _react.useState)(() => Date.now());
  const refreshPaused = (0, _reactRedux.useSelector)(_state.selectRefreshPaused);
  (0, _react.useEffect)(() => {
    const interVal = setInterval(() => {
      setRefresh(Date.now());
    }, 5000);
    return () => {
      clearInterval(interVal);
    };
  }, []);
  (0, _react.useEffect)(() => {
    setRefresh(Date.now());
  }, [lastRefreshed]);
  if (!lastRefreshed || refreshPaused) {
    return null;
  }
  const isWarning = (0, _moment.default)().diff((0, _moment.default)(lastRefreshed), 'minutes') > 1;
  const isDanger = (0, _moment.default)().diff((0, _moment.default)(lastRefreshed), 'minutes') > 5;
  const updatedDate = (0, _moment.default)(lastRefreshed).from(refresh);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: isDanger ? 'danger' : isWarning ? 'warning' : 'subdued',
    size: "s",
    css: {
      lineHeight: '40px',
      fontWeight: isWarning ? 'bold' : undefined
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.lastUpdated.label",
    defaultMessage: "Updated {updatedDate}",
    values: {
      updatedDate
    }
  }));
}