"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeOverviewNavigatorParams = void 0;
var _public = require("@kbn/observability-plugin/public");
var _ui = require("../../../common/constants/ui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatSearchKey = (key, value) => `${key}: "${value}"`;
async function navigate({
  ip,
  host,
  container,
  pod
}) {
  const searchParams = [];
  if (host) searchParams.push(formatSearchKey('host.name', host));
  if (container) searchParams.push(formatSearchKey('container.id', container));
  if (pod) searchParams.push(formatSearchKey('kubernetes.pod.uid', pod));
  if (ip) {
    searchParams.push(formatSearchKey(`host.ip`, ip));
    searchParams.push(formatSearchKey(`monitor.ip`, ip));
  }
  const searchString = searchParams.join(' OR ');
  const path = searchParams.length === 0 ? _ui.OVERVIEW_ROUTE : _ui.OVERVIEW_ROUTE + `?search=${searchString}`;
  return {
    app: 'uptime',
    path,
    state: {}
  };
}
const uptimeOverviewNavigatorParams = {
  id: _public.uptimeOverviewLocatorID,
  getLocation: navigate
};
exports.uptimeOverviewNavigatorParams = uptimeOverviewNavigatorParams;