"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SlackParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  errors,
  messageVariables,
  defaultMessage,
  useDefaultMessage
}) => {
  var _config$allowedChanne, _config, _errors$channels, _errors$text;
  const [connectorId, setConnectorId] = (0, _react.useState)();
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    channels = [],
    text,
    channelIds = []
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const [tempChannelId, setTempChannelId] = (0, _react.useState)(channels.length > 0 ? channels[0] : channelIds.length > 0 && channelIds[0].length > 0 ? channelIds[0] : '');
  const [validChannelId, setValidChannelId] = (0, _react.useState)('');
  const {
    toasts
  } = (0, _public.useKibana)().notifications;
  const allowedChannelsConfig = (_config$allowedChanne = actionConnector === null || actionConnector === void 0 ? void 0 : (_config = actionConnector.config) === null || _config === void 0 ? void 0 : _config.allowedChannels) !== null && _config$allowedChanne !== void 0 ? _config$allowedChanne : [];
  const [selectedChannels, setSelectedChannels] = (0, _react.useState)((channelIds !== null && channelIds !== void 0 ? channelIds : []).map(c => {
    const allowedChannelSelected = allowedChannelsConfig === null || allowedChannelsConfig === void 0 ? void 0 : allowedChannelsConfig.find(ac => ac.id === c);
    return {
      value: c,
      label: allowedChannelSelected ? `${allowedChannelSelected.id} - ${allowedChannelSelected.name}` : c
    };
  }));
  const [channelValidError, setChannelValidError] = (0, _react.useState)([]);
  const {
    response: {
      channel: channelValidInfo
    } = {},
    isLoading: isValidatingChannel,
    error: channelValidErrorResp
  } = (0, _public.useSubAction)({
    connectorId: actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id,
    subAction: 'validChannelId',
    subActionParams: {
      channelId: validChannelId
    },
    disabled: validChannelId.length === 0 && allowedChannelsConfig.length === 0
  });
  (0, _react.useEffect)(() => {
    if (useDefaultMessage || !text) {
      editAction('subActionParams', {
        channels,
        channelIds,
        text: defaultMessage
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [defaultMessage, useDefaultMessage]);
  (0, _react.useEffect)(() => {
    if (!isValidatingChannel && !channelValidErrorResp && channelValidInfo && validChannelId === channelValidInfo.id) {
      editAction('subActionParams', {
        channels: undefined,
        channelIds: [channelValidInfo.id],
        text
      }, index);
      setValidChannelId('');
      setChannelValidError([]);
    }
  }, [channelValidInfo, validChannelId, channelValidErrorResp, isValidatingChannel, editAction, text, index]);
  (0, _react.useEffect)(() => {
    if (channelValidErrorResp && validChannelId.length > 0) {
      editAction('subActionParams', {
        channels: undefined,
        channelIds: [],
        text
      }, index);
      const errorMessage = _i18n.i18n.translate('xpack.stackConnectors.slack.params.componentError.validChannelsRequestFailed', {
        defaultMessage: '{validChannelId} is not a valid Slack channel',
        values: {
          validChannelId
        }
      });
      setChannelValidError([errorMessage]);
      setValidChannelId('');
      toasts.danger({
        title: errorMessage,
        body: channelValidErrorResp.message
      });
    }
  }, [toasts, channelValidErrorResp, validChannelId, editAction, text, index]);
  (0, _react.useEffect)(() => {
    var _actionConnector$id;
    // Reset channel id input when we changes connector
    if (connectorId && connectorId !== (actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id)) {
      editAction('subActionParams', {
        channels: undefined,
        channelIds: [],
        text
      }, index);
      setTempChannelId('');
      setValidChannelId('');
      setChannelValidError([]);
      setSelectedChannels([]);
    }
    setConnectorId((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '');
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id]);
  if (!subAction) {
    editAction('subAction', 'postMessage', index);
  }
  if (!subActionParams) {
    editAction('subActionParams', {
      channels,
      channelIds,
      text
    }, index);
  }
  const typeChannelInput = (0, _react.useMemo)(() => {
    var _config$allowedChanne2, _config2;
    if (channels.length > 0 && channelIds.length === 0) {
      return 'channel-name';
    } else if (((_config$allowedChanne2 = actionConnector === null || actionConnector === void 0 ? void 0 : (_config2 = actionConnector.config) === null || _config2 === void 0 ? void 0 : _config2.allowedChannels) !== null && _config$allowedChanne2 !== void 0 ? _config$allowedChanne2 : []).length > 0) {
      return 'channel-allowed-ids';
    }
    return 'channel-id';
  }, [actionConnector, channelIds.length, channels.length]);
  const slackChannelsOptions = (0, _react.useMemo)(() => {
    var _config$allowedChanne3, _config3;
    return ((_config$allowedChanne3 = actionConnector === null || actionConnector === void 0 ? void 0 : (_config3 = actionConnector.config) === null || _config3 === void 0 ? void 0 : _config3.allowedChannels) !== null && _config$allowedChanne3 !== void 0 ? _config$allowedChanne3 : []).map(ac => ({
      label: `${ac.id} - ${ac.name}`,
      value: ac.id,
      'data-test-subj': ac.id
    }));
  }, [actionConnector]);
  const onChangeComboBox = (0, _react.useCallback)(newOptions => {
    const newSelectedChannels = newOptions.map(option => option.value.toString());
    setSelectedChannels(newOptions);
    editAction('subActionParams', {
      channels: undefined,
      channelIds: newSelectedChannels,
      text
    }, index);
  }, [editAction, index, text]);
  const onBlurChannelIds = (0, _react.useCallback)(() => {
    if (tempChannelId === '') {
      editAction('subActionParams', {
        channels: undefined,
        channelIds: [],
        text
      }, index);
    }
    setValidChannelId(tempChannelId.trim());
  }, [editAction, index, tempChannelId, text]);
  const onChangeTextField = (0, _react.useCallback)(evt => {
    editAction('subActionParams', {
      channels: undefined,
      channelIds: [],
      text
    }, index);
    setTempChannelId(evt.target.value);
  }, [editAction, index, text]);
  const channelInput = (0, _react.useMemo)(() => {
    if (typeChannelInput === 'channel-name' || typeChannelInput === 'channel-id') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-test-subj": "slackApiChannelId",
        name: "slackApiChannelId",
        value: tempChannelId,
        isLoading: isValidatingChannel,
        onChange: onChangeTextField,
        onBlur: onBlurChannelIds,
        isInvalid: channelValidError.length > 0,
        fullWidth: true
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      noSuggestions: false,
      "data-test-subj": "slackChannelsComboBox",
      options: slackChannelsOptions,
      selectedOptions: selectedChannels,
      onChange: onChangeComboBox,
      singleSelection: true,
      fullWidth: true
    });
  }, [channelValidError.length, isValidatingChannel, onBlurChannelIds, onChangeComboBox, onChangeTextField, selectedChannels, slackChannelsOptions, tempChannelId, typeChannelInput]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: typeChannelInput === 'channel-name' ? _i18n.i18n.translate('xpack.stackConnectors.slack.params.channelsComboBoxLabel', {
      defaultMessage: 'Channel'
    }) : _i18n.i18n.translate('xpack.stackConnectors.slack.params.channelIdComboBoxLabel', {
      defaultMessage: 'Channel ID'
    }),
    fullWidth: true,
    error: channelValidError.length > 0 ? channelValidError : errors.channels,
    isInvalid: ((_errors$channels = errors.channels) === null || _errors$channels === void 0 ? void 0 : _errors$channels.length) > 0 || channelValidError.length > 0,
    helpText: channelIds.length > 0 && channelValidInfo ? `${channelValidInfo.id} - ${channelValidInfo.name}` : ''
  }, channelInput), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: (key, value) => editAction('subActionParams', {
      channels,
      channelIds,
      text: value
    }, index),
    messageVariables: messageVariables,
    paramsProperty: "webApi",
    inputTargetValue: text,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.slack.messageTextAreaFieldLabel', {
      defaultMessage: 'Message'
    }),
    errors: (_errors$text = errors.text) !== null && _errors$text !== void 0 ? _errors$text : []
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = SlackParamsFields;
module.exports = exports.default;