"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simpleConnectorQueryClient = exports.default = exports.SlackActionFieldsComponents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _lodash = require("lodash");
var _reactQuery = require("@tanstack/react-query");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_valid_channels = require("./use_valid_channels");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** wait this many ms after the user completes typing before applying the filter input */
const INPUT_TIMEOUT = 250;
const getSecretsFormSchema = docLinks => [{
  id: 'token',
  label: i18n.TOKEN_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.alerting.slackApiAction,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.slack_api.apiKeyDocumentation",
    defaultMessage: "Create a Slack Web API token"
  }))
}];
const getConfigFormSchemaAfterSecrets = ({
  options,
  isLoading,
  isDisabled,
  onChange,
  onCreateOption,
  selectedOptions
}) => [{
  id: 'allowedChannels',
  isRequired: true,
  label: i18n.ALLOWED_CHANNELS,
  type: 'COMBO_BOX',
  euiFieldProps: {
    noSuggestions: true,
    isDisabled,
    isLoading,
    options,
    onChange,
    onCreateOption,
    selectedOptions
  }
}];
const NO_SCHEMA = [];
const SEPARATOR = ' - ';
const SlackActionFieldsComponents = ({
  readOnly,
  isEdit
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  const form = (0, _hook_form_lib.useFormContext)();
  const {
    setFieldValue
  } = form;
  const [formData] = (0, _hook_form_lib.useFormData)({
    form
  });
  const [authToken, setAuthToken] = (0, _react.useState)('');
  const [channelsToValidate, setChannelsToValidate] = (0, _react.useState)('');
  const {
    channels: validChannels,
    isLoading,
    resetChannelsToValidate
  } = (0, _use_valid_channels.useValidChannels)({
    authToken,
    channelId: channelsToValidate
  });
  const onCreateOption = (0, _react.useCallback)((searchValue, options) => {
    setChannelsToValidate(searchValue);
  }, []);
  const onChange = (0, _react.useCallback)(options => {
    const tempChannelIds = options.map(opt => {
      return opt.value;
    });
    setChannelsToValidate('');
    resetChannelsToValidate(tempChannelIds);
  }, [resetChannelsToValidate]);
  const configFormSchemaAfterSecrets = (0, _react.useMemo)(() => {
    const validChannelsFormatted = validChannels.map(channel => ({
      label: `${channel.id}${SEPARATOR}${channel.name}`,
      value: channel
    }));
    return getConfigFormSchemaAfterSecrets({
      options: validChannelsFormatted,
      isLoading,
      isDisabled: (authToken || '').length === 0,
      onChange,
      onCreateOption,
      selectedOptions: validChannelsFormatted
    });
  }, [validChannels, isLoading, authToken, onChange, onCreateOption]);
  const debounceSetToken = (0, _lodash.debounce)(setAuthToken, INPUT_TIMEOUT);
  (0, _react.useEffect)(() => {
    if (formData.secrets && formData.secrets.token !== authToken) {
      debounceSetToken(formData.secrets.token);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [formData.secrets]);
  (0, _react.useEffect)(() => {
    if ((0, _lodash.isEmpty)(authToken) && validChannels.length > 0) {
      setFieldValue('config.allowedChannels', []);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [authToken]);
  (0, _react.useEffect)(() => {
    var _formData$config;
    const configAllowedChannels = (formData === null || formData === void 0 ? void 0 : (_formData$config = formData.config) === null || _formData$config === void 0 ? void 0 : _formData$config.allowedChannels) || [];
    if (!(0, _lodash.isEqual)(configAllowedChannels, validChannels)) {
      setFieldValue('config.allowedChannels', validChannels);
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [validChannels]);
  const isInitialyzed = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    var _formData$config2;
    const configAllowedChannels = (formData === null || formData === void 0 ? void 0 : (_formData$config2 = formData.config) === null || _formData$config2 === void 0 ? void 0 : _formData$config2.allowedChannels) || [];
    if (!isInitialyzed.current && configAllowedChannels.length > 0 && !(0, _lodash.isEqual)(configAllowedChannels, validChannels)) {
      isInitialyzed.current = true;
      resetChannelsToValidate(formData.config.allowedChannels);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [formData.config]);
  return /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: NO_SCHEMA,
    secretsFormSchema: getSecretsFormSchema(docLinks),
    configFormSchemaAfterSecrets: configFormSchemaAfterSecrets
  });
};
exports.SlackActionFieldsComponents = SlackActionFieldsComponents;
const simpleConnectorQueryClient = new _reactQuery.QueryClient();
exports.simpleConnectorQueryClient = simpleConnectorQueryClient;
const SlackActionFields = props => /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
  client: simpleConnectorQueryClient
}, /*#__PURE__*/_react.default.createElement(SlackActionFieldsComponents, props));

// eslint-disable-next-line import/no-default-export
exports.default = SlackActionFields;