"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEBHOOK_URL_PLACEHOLDER = exports.WEBHOOK_URL_LABEL = exports.WEBHOOK_URL_HELP = exports.WEBHOOK_URL_FALLBACK_TITLE = exports.WEBHOOK_URL_FALLBACK_TEXT = exports.WEBHOOK_SECRET_REQUIRED = exports.WEBHOOK_REQUIRED = exports.WEBHOOK_PLACEHOLDER = exports.WEBHOOK_PATH_REQUIRED = exports.WEBHOOK_NOT_FOUND_WARNING = exports.WEBHOOK_LABEL = exports.WEBHOOK_HELP = exports.WEBHOOK_DISABLED_PLACEHOLDER = exports.WEBHOOK_ARIA_LABEL = exports.WEBHOOKS_ERROR = exports.URL_LABEL = exports.TOKEN_LABEL = exports.STORY_REQUIRED = exports.STORY_NOT_FOUND_WARNING = exports.STORY_ARIA_LABEL = exports.SCRIPT_TYPE_FILTER_LABEL = exports.REMOTE_SCRIPTS_ERROR = exports.RELEASE_AGENT_ACTION_LABEL = exports.OS_TYPES_FILTER_LABEL = exports.KILL_PROCESS_ACTION_LABEL = exports.ISOLATE_AGENT_ACTION_LABEL = exports.INVALID_ACTION = exports.DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = exports.COMMAND_LABEL = exports.CHANGE_ACTION_LABEL = exports.BODY_REQUIRED = exports.BODY_LABEL = exports.BODY_INVALID = exports.ASC = exports.AGENTS_FIELD_PLACEHOLDER = exports.AGENTS_FIELD_LABEL = exports.AGENTS_ERROR = exports.ACTION_TYPE_LABEL = exports.ACTION_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/sentinelone/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// config form
const URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.config.urlTextFieldLabel', {
  defaultMessage: 'SentinelOne tenant URL'
});
exports.URL_LABEL = URL_LABEL;
const TOKEN_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.config.tokenTextFieldLabel', {
  defaultMessage: 'API token'
});

// params form
exports.TOKEN_LABEL = TOKEN_LABEL;
const ASC = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.storyFieldLabel', {
  defaultMessage: 'SentinelOne Script'
});
exports.ASC = ASC;
const SCRIPT_TYPE_FILTER_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.scriptTypeFilterLabel', {
  defaultMessage: 'Script type'
});
exports.SCRIPT_TYPE_FILTER_LABEL = SCRIPT_TYPE_FILTER_LABEL;
const OS_TYPES_FILTER_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.osTypesFilterLabel', {
  defaultMessage: 'OS'
});
exports.OS_TYPES_FILTER_LABEL = OS_TYPES_FILTER_LABEL;
const STORY_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.storyFieldAriaLabel', {
  defaultMessage: 'Select a SentinelOne script'
});
exports.STORY_ARIA_LABEL = STORY_ARIA_LABEL;
const KILL_PROCESS_ACTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.killProcessActionLabel', {
  defaultMessage: 'Kill process'
});
exports.KILL_PROCESS_ACTION_LABEL = KILL_PROCESS_ACTION_LABEL;
const ISOLATE_AGENT_ACTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.isolateAgentActionLabel', {
  defaultMessage: 'Isolate agent'
});
exports.ISOLATE_AGENT_ACTION_LABEL = ISOLATE_AGENT_ACTION_LABEL;
const RELEASE_AGENT_ACTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.releaseAgentActionLabel', {
  defaultMessage: 'Release agent'
});
exports.RELEASE_AGENT_ACTION_LABEL = RELEASE_AGENT_ACTION_LABEL;
const AGENTS_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.agentsFieldLabel', {
  defaultMessage: 'SentinelOne agent'
});
exports.AGENTS_FIELD_LABEL = AGENTS_FIELD_LABEL;
const AGENTS_FIELD_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.agentsFieldPlaceholder', {
  defaultMessage: 'Select a single agent'
});
exports.AGENTS_FIELD_PLACEHOLDER = AGENTS_FIELD_PLACEHOLDER;
const ACTION_TYPE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.actionTypeFieldLabel', {
  defaultMessage: 'Action Type'
});
exports.ACTION_TYPE_LABEL = ACTION_TYPE_LABEL;
const COMMAND_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.commandFieldLabel', {
  defaultMessage: 'Command'
});
exports.COMMAND_LABEL = COMMAND_LABEL;
const CHANGE_ACTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.changeActionButton', {
  defaultMessage: 'Change action'
});
exports.CHANGE_ACTION_LABEL = CHANGE_ACTION_LABEL;
const WEBHOOK_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookFieldLabel', {
  defaultMessage: 'SentinelOne Webhook action'
});
exports.WEBHOOK_LABEL = WEBHOOK_LABEL;
const WEBHOOK_HELP = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookHelp', {
  defaultMessage: 'The data entry action in the story'
});
exports.WEBHOOK_HELP = WEBHOOK_HELP;
const WEBHOOK_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookPlaceholder', {
  defaultMessage: 'Select a webhook action'
});
exports.WEBHOOK_PLACEHOLDER = WEBHOOK_PLACEHOLDER;
const WEBHOOK_DISABLED_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookDisabledPlaceholder', {
  defaultMessage: 'Select a story first'
});
exports.WEBHOOK_DISABLED_PLACEHOLDER = WEBHOOK_DISABLED_PLACEHOLDER;
const WEBHOOK_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookFieldAriaLabel', {
  defaultMessage: 'Select a SentinelOne webhook action'
});
exports.WEBHOOK_ARIA_LABEL = WEBHOOK_ARIA_LABEL;
const WEBHOOK_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookUrlFieldLabel', {
  defaultMessage: 'Webhook URL'
});
exports.WEBHOOK_URL_LABEL = WEBHOOK_URL_LABEL;
const WEBHOOK_URL_FALLBACK_TITLE = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookUrlFallbackTitle', {
  defaultMessage: 'SentinelOne API results limit reached'
});
exports.WEBHOOK_URL_FALLBACK_TITLE = WEBHOOK_URL_FALLBACK_TITLE;
const WEBHOOK_URL_FALLBACK_TEXT = entity => _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookUrlFallbackText', {
  values: {
    entity,
    limit: _constants.API_MAX_RESULTS
  },
  defaultMessage: `Not possible to retrieve more than {limit} results from the SentinelOne {entity} API. If your {entity} does not appear in the list, please fill the Webhook URL below`
});
exports.WEBHOOK_URL_FALLBACK_TEXT = WEBHOOK_URL_FALLBACK_TEXT;
const WEBHOOK_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookUrlHelp', {
  defaultMessage: 'The Story and Webhook selectors will be ignored if the Webhook URL is defined'
});
exports.WEBHOOK_URL_HELP = WEBHOOK_URL_HELP;
const WEBHOOK_URL_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.webhookUrlPlaceholder', {
  defaultMessage: 'Paste the Webhook URL here'
});
exports.WEBHOOK_URL_PLACEHOLDER = WEBHOOK_URL_PLACEHOLDER;
const DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.disabledByWebhookUrlPlaceholder', {
  defaultMessage: 'Remove the Webhook URL to use this selector'
});
exports.DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = DISABLED_BY_WEBHOOK_URL_PLACEHOLDER;
const BODY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.bodyFieldLabel', {
  defaultMessage: 'Body'
});
exports.BODY_LABEL = BODY_LABEL;
const AGENTS_ERROR = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.componentError.storiesRequestFailed', {
  defaultMessage: 'Error retrieving agent from SentinelOne'
});
exports.AGENTS_ERROR = AGENTS_ERROR;
const REMOTE_SCRIPTS_ERROR = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.componentError.remoteScriptsRequestFailed', {
  defaultMessage: 'Error retrieving remote scripts from SentinelOne'
});
exports.REMOTE_SCRIPTS_ERROR = REMOTE_SCRIPTS_ERROR;
const WEBHOOKS_ERROR = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.componentError.webhooksRequestFailed', {
  defaultMessage: 'Error retrieving webhook actions from SentinelOne'
});
exports.WEBHOOKS_ERROR = WEBHOOKS_ERROR;
const STORY_NOT_FOUND_WARNING = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.componentWarning.storyNotFound', {
  defaultMessage: 'Cannot find the saved story. Please select a valid story from the selector'
});
exports.STORY_NOT_FOUND_WARNING = STORY_NOT_FOUND_WARNING;
const WEBHOOK_NOT_FOUND_WARNING = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.componentWarning.webhookNotFound', {
  defaultMessage: 'Cannot find the saved webhook. Please select a valid webhook from the selector'
});
exports.WEBHOOK_NOT_FOUND_WARNING = WEBHOOK_NOT_FOUND_WARNING;
const ACTION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.error.requiredActionText', {
  defaultMessage: 'Action is required.'
});
exports.ACTION_REQUIRED = ACTION_REQUIRED;
const INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.error.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
exports.INVALID_ACTION = INVALID_ACTION;
const BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.error.requiredBodyText', {
  defaultMessage: 'Body is required.'
});
exports.BODY_REQUIRED = BODY_REQUIRED;
const BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.error.invalidBodyText', {
  defaultMessage: 'Body does not have a valid JSON format.'
});
exports.BODY_INVALID = BODY_INVALID;
const STORY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.error.requiredStoryText', {
  defaultMessage: 'Story is required.'
});
exports.STORY_REQUIRED = STORY_REQUIRED;
const WEBHOOK_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.error.requiredWebhookText', {
  defaultMessage: 'Webhook is required.'
});
exports.WEBHOOK_REQUIRED = WEBHOOK_REQUIRED;
const WEBHOOK_PATH_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.error.requiredWebhookPathText', {
  defaultMessage: 'Webhook action path is missing.'
});
exports.WEBHOOK_PATH_REQUIRED = WEBHOOK_PATH_REQUIRED;
const WEBHOOK_SECRET_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.sentinelone.params.error.requiredWebhookSecretText', {
  defaultMessage: 'Webhook action secret is missing.'
});
exports.WEBHOOK_SECRET_REQUIRED = WEBHOOK_SECRET_REQUIRED;