"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUMMARY_REQUIRED = exports.OPTIONAL_LABEL = exports.INTEGRATION_KEY_REQUIRED = exports.INTEGRATION_KEY_LABEL = exports.DEDUP_KEY_REQUIRED = exports.API_URL_LABEL = exports.API_URL_INVALID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUMMARY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.requiredSummaryText', {
  defaultMessage: 'Summary is required.'
});
exports.SUMMARY_REQUIRED = SUMMARY_REQUIRED;
const DEDUP_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.requiredDedupKeyText', {
  defaultMessage: 'DedupKey is required when resolving or acknowledging an incident.'
});
exports.DEDUP_KEY_REQUIRED = DEDUP_KEY_REQUIRED;
const INTEGRATION_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.requiredRoutingKeyText', {
  defaultMessage: 'An integration key / routing key is required.'
});
exports.INTEGRATION_KEY_REQUIRED = INTEGRATION_KEY_REQUIRED;
const API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.apiUrlTextFieldLabel', {
  defaultMessage: 'API URL'
});
exports.API_URL_LABEL = API_URL_LABEL;
const API_URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.apiUrlInvalid', {
  defaultMessage: 'Invalid API URL'
});
exports.API_URL_INVALID = API_URL_INVALID;
const INTEGRATION_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.routingKeyTextFieldLabel', {
  defaultMessage: 'Integration key'
});
exports.INTEGRATION_KEY_LABEL = INTEGRATION_KEY_LABEL;
const OPTIONAL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.optionalLabel', {
  defaultMessage: 'Optional'
});
exports.OPTIONAL_LABEL = OPTIONAL_LABEL;