"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _lodash = require("lodash");
var _types = require("../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
function getConnectorType() {
  return {
    id: '.pagerduty',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.selectMessageText', {
      defaultMessage: 'Send an event in PagerDuty.'
    }),
    actionTypeTitle: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.connectorTypeTitle', {
      defaultMessage: 'Send to PagerDuty'
    }),
    validateParams: async actionParams => {
      var _actionParams$dedupKe, _actionParams$summary, _actionParams$customD;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        summary: new Array(),
        timestamp: new Array(),
        dedupKey: new Array(),
        links: new Array(),
        customDetails: new Array()
      };
      const validationResult = {
        errors
      };
      if (!((_actionParams$dedupKe = actionParams.dedupKey) !== null && _actionParams$dedupKe !== void 0 && _actionParams$dedupKe.length) && (actionParams.eventAction === 'resolve' || actionParams.eventAction === 'acknowledge')) {
        errors.dedupKey.push(translations.DEDUP_KEY_REQUIRED);
      }
      if (actionParams.eventAction === _types.EventActionOptions.TRIGGER && !((_actionParams$summary = actionParams.summary) !== null && _actionParams$summary !== void 0 && _actionParams$summary.length)) {
        errors.summary.push(translations.SUMMARY_REQUIRED);
      }
      if (actionParams.timestamp && !(0, _public.hasMustacheTokens)(actionParams.timestamp)) {
        if (!(0, _moment.default)(actionParams.timestamp).isValid()) {
          const {
            nowShortFormat,
            nowLongFormat
          } = getValidTimestampExamples();
          errors.timestamp.push(_i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.invalidTimestamp', {
            defaultMessage: 'Timestamp must be a valid date, such as {nowShortFormat} or {nowLongFormat}.',
            values: {
              nowShortFormat,
              nowLongFormat
            }
          }));
        }
      }
      if (Array.isArray(actionParams.links)) {
        actionParams.links.forEach(({
          href,
          text
        }) => {
          if ((!href || !text) && errors.links.length === 0) {
            errors.links.push(_i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.invalidLink', {
              defaultMessage: 'Link properties cannot be empty.'
            }));
          }
        });
      }
      if ((_actionParams$customD = actionParams.customDetails) !== null && _actionParams$customD !== void 0 && _actionParams$customD.length) {
        const errorMessage = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.invalidCustomDetails', {
          defaultMessage: 'Custom details must be a valid JSON object.'
        });
        try {
          const parsedJSON = JSON.parse(actionParams.customDetails);
          if (!(0, _lodash.isPlainObject)(parsedJSON)) {
            errors.customDetails.push(errorMessage);
          }
        } catch {
          errors.customDetails.push(errorMessage);
        }
      }
      return validationResult;
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pagerduty_connectors')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pagerduty_params')))),
    defaultActionParams: {
      dedupKey: `{{${_public.AlertProvidedActionVariables.ruleId}}}:{{${_public.AlertProvidedActionVariables.alertId}}}`,
      eventAction: _types.EventActionOptions.TRIGGER
    },
    defaultRecoveredActionParams: {
      dedupKey: `{{${_public.AlertProvidedActionVariables.ruleId}}}:{{${_public.AlertProvidedActionVariables.alertId}}}`,
      eventAction: _types.EventActionOptions.RESOLVE
    }
  };
}
function getValidTimestampExamples() {
  const now = (0, _moment.default)();
  return {
    nowShortFormat: now.format('YYYY-MM-DD'),
    nowLongFormat: now.format('YYYY-MM-DD h:mm:ss')
  };
}