"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _common = require("../../../common");
var _opsgenie = require("../../../common/opsgenie");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const SELECT_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.selectMessageText', {
  defaultMessage: 'Create or close an alert in Opsgenie.'
});
const TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.connectorTypeTitle', {
  defaultMessage: 'Opsgenie'
});
const getConnectorType = () => {
  return {
    id: '.opsgenie',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: SELECT_MESSAGE,
    actionTypeTitle: TITLE,
    validateParams,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./params')))),
    defaultActionParams: {
      subAction: _common.OpsgenieSubActions.CreateAlert,
      subActionParams: {
        alias: _constants.DEFAULT_ALIAS,
        tags: [_opsgenie.RULE_TAGS_TEMPLATE]
      }
    },
    defaultRecoveredActionParams: {
      subAction: _common.OpsgenieSubActions.CloseAlert,
      subActionParams: {
        alias: _constants.DEFAULT_ALIAS
      }
    }
  };
};
exports.getConnectorType = getConnectorType;
const validateParams = async actionParams => {
  var _actionParams$subActi5, _actionParams$subActi6;
  const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
  const errors = {
    'subActionParams.message': new Array(),
    'subActionParams.alias': new Array(),
    jsonEditorError: new Array()
  };
  const validationResult = {
    errors
  };
  if (actionParams.subAction === _common.OpsgenieSubActions.CreateAlert) {
    var _actionParams$subActi, _actionParams$subActi2, _actionParams$subActi3, _actionParams$subActi4;
    if (!(actionParams !== null && actionParams !== void 0 && (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 && (_actionParams$subActi2 = _actionParams$subActi.message) !== null && _actionParams$subActi2 !== void 0 && _actionParams$subActi2.length)) {
      errors['subActionParams.message'].push(translations.MESSAGE_IS_REQUIRED);
    } else if ((0, _lodash.isEmpty)(actionParams === null || actionParams === void 0 ? void 0 : (_actionParams$subActi3 = actionParams.subActionParams) === null || _actionParams$subActi3 === void 0 ? void 0 : (_actionParams$subActi4 = _actionParams$subActi3.message) === null || _actionParams$subActi4 === void 0 ? void 0 : _actionParams$subActi4.trim())) {
      errors['subActionParams.message'].push(translations.MESSAGE_NON_WHITESPACE);
    }
  }
  if (actionParams.subAction === _common.OpsgenieSubActions.CloseAlert && !(actionParams !== null && actionParams !== void 0 && (_actionParams$subActi5 = actionParams.subActionParams) !== null && _actionParams$subActi5 !== void 0 && (_actionParams$subActi6 = _actionParams$subActi5.alias) !== null && _actionParams$subActi6 !== void 0 && _actionParams$subActi6.length)) {
    errors['subActionParams.alias'].push(translations.ALIAS_IS_REQUIRED);
  }
  if (actionParams.jsonEditorError) {
    // This error doesn't actually get displayed it is used to cause the run/save button to fail within the action form
    errors.jsonEditorError.push(translations.JSON_EDITOR_ERROR);
  }
  return validationResult;
};