"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForComponentToUpdate = exports.createAppMockRenderer = exports.ConnectorFormTestProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _testUtils = require("react-dom/test-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@testing-library/react");
var _kibana_react = require("@kbn/triggers-actions-ui-plugin/public/common/lib/kibana/kibana_react.mock");
var _connector_form_fields_global = require("@kbn/triggers-actions-ui-plugin/public/application/sections/action_connector_form/connector_form_fields_global");
var _connector_context = require("@kbn/triggers-actions-ui-plugin/public/application/context/connector_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorFormTestProviderComponent = ({
  children,
  connector,
  onSubmit,
  connectorServices
}) => {
  return /*#__PURE__*/_react.default.createElement(FormTestProviderComponent, {
    defaultValue: connector,
    onSubmit: onSubmit,
    connectorServices: connectorServices
  }, /*#__PURE__*/_react.default.createElement(_connector_form_fields_global.ConnectorFormFieldsGlobal, {
    canSave: true
  }), children);
};
ConnectorFormTestProviderComponent.displayName = 'ConnectorFormTestProvider';
const ConnectorFormTestProvider = /*#__PURE__*/_react.default.memo(ConnectorFormTestProviderComponent);
exports.ConnectorFormTestProvider = ConnectorFormTestProvider;
const FormTestProviderComponent = ({
  children,
  defaultValue,
  onSubmit,
  connectorServices = {
    validateEmailAddresses: jest.fn()
  }
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue
  });
  const {
    submit
  } = form;
  const onClick = (0, _react.useCallback)(async () => {
    const res = await submit();
    if (onSubmit) {
      onSubmit(res);
    }
  }, [onSubmit, submit]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_connector_context.ConnectorProvider, {
    value: {
      services: connectorServices
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "form-test-provide-submit",
    onClick: onClick
  })));
};
const waitForComponentToUpdate = async () => await (0, _testUtils.act)(async () => {
  return Promise.resolve();
});
exports.waitForComponentToUpdate = waitForComponentToUpdate;
const createAppMockRenderer = () => {
  const services = (0, _kibana_react.createStartServicesMock)();
  const theme$ = (0, _rxjs.of)({
    darkMode: false
  });
  const AppWrapper = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, children)));
  AppWrapper.displayName = 'AppWrapper';
  const render = (ui, options) => {
    return (0, _react2.render)(ui, {
      wrapper: AppWrapper,
      ...options
    });
  };
  return {
    coreStart: services,
    render
  };
};
exports.createAppMockRenderer = createAppMockRenderer;