"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAppInfo = getAppInfo;
exports.getChoices = getChoices;
var _common = require("@kbn/actions-plugin/common");
var _servicenow_config = require("../../../../common/servicenow_config");
var _translations = require("./translations");
var _rewrite_response_body = require("../rewrite_response_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getChoices({
  http,
  signal,
  connectorId,
  fields
}) {
  const res = await http.post(`${_common.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(connectorId)}/_execute`, {
    body: JSON.stringify({
      params: {
        subAction: 'getChoices',
        subActionParams: {
          fields
        }
      }
    }),
    signal
  });
  return (0, _rewrite_response_body.rewriteResponseToCamelCase)(res);
}

/**
 * The app info url should be the same as at:
 * x-pack/plugins/stack_connectors/server/connector_types/cases/servicenow/service.ts
 */
const getAppInfoUrl = (url, scope) => `${url}/api/${scope}/elastic_api/health`;
async function getAppInfo({
  http,
  signal,
  connector,
  actionTypeId
}) {
  var _config$appScope;
  const {
    secrets: {
      username,
      password,
      clientSecret,
      privateKey,
      privateKeyPassword
    },
    config: {
      isOAuth,
      apiUrl,
      clientId,
      userIdentifierValue,
      jwtKeyId
    }
  } = connector;
  const urlWithoutTrailingSlash = apiUrl.endsWith('/') ? apiUrl.slice(0, -1) : apiUrl;
  let authHeader = 'Basic ' + btoa(username + ':' + password);
  if (isOAuth) {
    const tokenResponse = await http.post(`${_common.INTERNAL_BASE_ACTION_API_PATH}/connector/_oauth_access_token`, {
      body: JSON.stringify({
        type: 'jwt',
        options: {
          tokenUrl: `${urlWithoutTrailingSlash}/oauth_token.do`,
          config: {
            clientId,
            userIdentifierValue,
            jwtKeyId
          },
          secrets: {
            clientSecret,
            privateKey,
            ...(privateKeyPassword && {
              privateKeyPassword
            })
          }
        }
      })
    });
    const {
      accessToken
    } = tokenResponse;
    authHeader = accessToken;
  }
  const config = _servicenow_config.snExternalServiceConfig[actionTypeId];
  const response = await fetch(getAppInfoUrl(urlWithoutTrailingSlash, (_config$appScope = config.appScope) !== null && _config$appScope !== void 0 ? _config$appScope : ''), {
    method: 'GET',
    signal,
    headers: {
      Authorization: authHeader
    }
  });
  if (!response.ok) {
    throw new Error((0, _translations.API_INFO_ERROR)(response.status));
  }
  const data = await response.json();
  return {
    ...data.result
  };
}