"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EmailParamsFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noop = () => {};
const EmailParamsFields = ({
  actionParams,
  editAction,
  index,
  errors,
  messageVariables,
  defaultMessage,
  isLoading,
  isDisabled,
  onBlur = noop,
  showEmailSubjectAndMessage = true,
  useDefaultMessage,
  ruleTypeId
}) => {
  var _errors$subject, _errors$message;
  const {
    to,
    cc,
    bcc,
    subject,
    message
  } = actionParams;
  const toOptions = to ? to.map(label => ({
    label
  })) : [];
  const ccOptions = cc ? cc.map(label => ({
    label
  })) : [];
  const bccOptions = bcc ? bcc.map(label => ({
    label
  })) : [];
  const [addCC, setAddCC] = (0, _react.useState)(false);
  const [addBCC, setAddBCC] = (0, _react.useState)(false);
  const [[isUsingDefault, defaultMessageUsed], setDefaultMessageUsage] = (0, _react.useState)([false, defaultMessage]);
  (0, _react.useEffect)(() => {
    if (useDefaultMessage || !(actionParams !== null && actionParams !== void 0 && actionParams.message) || isUsingDefault && (actionParams === null || actionParams === void 0 ? void 0 : actionParams.message) === defaultMessageUsed && defaultMessageUsed !== defaultMessage) {
      setDefaultMessageUsage([true, defaultMessage]);
      editAction('message', defaultMessage, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [defaultMessage]);
  const isToInvalid = to !== undefined && errors.to !== undefined && errors.to.length > 0;
  const isSubjectInvalid = subject !== undefined && errors.subject !== undefined && errors.subject.length > 0;
  const isCCInvalid = errors.cc !== undefined && errors.cc.length > 0 && cc !== undefined;
  const isBCCInvalid = errors.bcc !== undefined && errors.bcc.length > 0 && bcc !== undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.to,
    isInvalid: isToInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.recipientTextFieldLabel', {
      defaultMessage: 'To'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, !addCC && (!cc || (cc === null || cc === void 0 ? void 0 : cc.length) === 0) ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: () => setAddCC(true)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Cc",
      id: "xpack.stackConnectors.components.email.addCcButton"
    })) : null, !addBCC && (!bcc || (bcc === null || bcc === void 0 ? void 0 : bcc.length) === 0) ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: () => setAddBCC(true)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Bcc",
      id: "xpack.stackConnectors.components.email.addBccButton"
    })) : null))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    isInvalid: isToInvalid,
    isLoading: isLoading,
    isDisabled: isDisabled,
    fullWidth: true,
    "data-test-subj": "toEmailAddressInput",
    selectedOptions: toOptions,
    onCreateOption: searchValue => {
      const newOptions = [...toOptions, {
        label: searchValue
      }];
      editAction('to', newOptions.map(newOption => newOption.label), index);
    },
    onChange: selectedOptions => {
      editAction('to', selectedOptions.map(selectedOption => selectedOption.label), index);
    },
    onBlur: () => {
      if (!to) {
        editAction('to', [], index);
      }
      onBlur('to');
    }
  })), addCC || cc && (cc === null || cc === void 0 ? void 0 : cc.length) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.cc,
    isInvalid: isCCInvalid,
    isDisabled: isDisabled,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.recipientCopyTextFieldLabel', {
      defaultMessage: 'Cc'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    isInvalid: isCCInvalid,
    isLoading: isLoading,
    fullWidth: true,
    "data-test-subj": "ccEmailAddressInput",
    selectedOptions: ccOptions,
    onCreateOption: searchValue => {
      const newOptions = [...ccOptions, {
        label: searchValue
      }];
      editAction('cc', newOptions.map(newOption => newOption.label), index);
    },
    onChange: selectedOptions => {
      editAction('cc', selectedOptions.map(selectedOption => selectedOption.label), index);
    },
    onBlur: () => {
      if (!cc) {
        editAction('cc', [], index);
      }
      onBlur('cc');
    }
  })) : null, addBCC || bcc && (bcc === null || bcc === void 0 ? void 0 : bcc.length) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.bcc,
    isInvalid: isBCCInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.recipientBccTextFieldLabel', {
      defaultMessage: 'Bcc'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    isInvalid: isBCCInvalid,
    isDisabled: isDisabled,
    isLoading: isLoading,
    fullWidth: true,
    "data-test-subj": "bccEmailAddressInput",
    selectedOptions: bccOptions,
    onCreateOption: searchValue => {
      const newOptions = [...bccOptions, {
        label: searchValue
      }];
      editAction('bcc', newOptions.map(newOption => newOption.label), index);
    },
    onChange: selectedOptions => {
      editAction('bcc', selectedOptions.map(selectedOption => selectedOption.label), index);
    },
    onBlur: () => {
      if (!bcc) {
        editAction('bcc', [], index);
      }
      onBlur('bcc');
    }
  })) : null, showEmailSubjectAndMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.subject,
    isInvalid: isSubjectInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.subjectTextFieldLabel', {
      defaultMessage: 'Subject'
    })
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'subject',
    inputTargetValue: subject,
    errors: (_errors$subject = errors.subject) !== null && _errors$subject !== void 0 ? _errors$subject : []
  })), showEmailSubjectAndMessage && /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'message',
    inputTargetValue: message,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.messageTextAreaFieldLabel', {
      defaultMessage: 'Message'
    }),
    errors: (_errors$message = errors.message) !== null && _errors$message !== void 0 ? _errors$message : []
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.EmailParamsFields = EmailParamsFields;