"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bedrockSecrets = exports.bedrockConfig = exports.DEFAULT_BODY = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/bedrock/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const human = '\n\nHuman:';
const assistant = '\n\nAssistant:';
const DEFAULT_BODY = JSON.stringify({
  prompt: `${human} Hello world! ${assistant}`,
  max_tokens_to_sample: _constants.DEFAULT_TOKEN_LIMIT,
  stop_sequences: [human]
});
exports.DEFAULT_BODY = DEFAULT_BODY;
const bedrockConfig = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: _constants.DEFAULT_BEDROCK_URL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Amazon Bedrock API endpoint URL. For more information on the URL, refer to the {bedrockAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.bedrock.bedrockDocumentation",
    values: {
      bedrockAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "bedrock-api-doc",
        href: "https://docs.aws.amazon.com/general/latest/gr/bedrock.html",
        target: "_blank"
      }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
    }
  })
}, {
  id: 'defaultModel',
  label: i18n.DEFAULT_MODEL_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Current support is for the Anthropic Claude models. The model can be set on a per request basis by including a \"model\" parameter alongside the request body. If no model is provided, the fallback will be the default model -  Claude 2. For more information, refer to the {bedrockAPIModelDocs}.",
    id: "xpack.stackConnectors.components.bedrock.bedrockDocumentationModel",
    values: {
      bedrockAPIModelDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "bedrock-api-model-doc",
        href: "https://aws.amazon.com/bedrock/claude/",
        target: "_blank"
      }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
    }
  }),
  defaultValue: _constants.DEFAULT_BEDROCK_MODEL
}];
exports.bedrockConfig = bedrockConfig;
const bedrockSecrets = [{
  id: 'accessKey',
  label: i18n.ACCESS_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The AWS access key for HTTP Basic authentication. For more details about generating AWS security credentials, refer to the {bedrockAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.bedrock.bedrockApiKeyDocumentation",
    values: {
      bedrockAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "aws-api-keys-doc",
        href: "https://docs.aws.amazon.com/IAM/latest/UserGuide/security-creds.html",
        target: "_blank"
      }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
    }
  })
}, {
  id: 'secret',
  label: i18n.SECRET,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The AWS secret for HTTP Basic authentication. For more details about generating AWS security credentials, refer to the {bedrockAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.bedrock.bedrockSecretDocumentation",
    values: {
      bedrockAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "aws-api-keys-doc",
        href: "https://docs.aws.amazon.com/IAM/latest/UserGuide/security-creds.html",
        target: "_blank"
      }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
    }
  })
}];
exports.bedrockSecrets = bedrockSecrets;