"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParsedQuery = getParsedQuery;
exports.isEsQueryRule = isEsQueryRule;
exports.isEsqlQueryRule = isEsqlQueryRule;
exports.isSearchSourceRule = isSearchSourceRule;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isEsQueryRule(searchType) {
  return searchType === 'esQuery';
}
function isSearchSourceRule(searchType) {
  return searchType === 'searchSource';
}
function isEsqlQueryRule(searchType) {
  return searchType === 'esqlQuery';
}
function getParsedQuery(queryParams) {
  const {
    esQuery
  } = queryParams;
  let parsedQuery;
  try {
    parsedQuery = JSON.parse(esQuery);
  } catch (err) {
    throw new Error(getInvalidQueryError(esQuery));
  }
  if (parsedQuery && !parsedQuery.query) {
    throw new Error(getInvalidQueryError(esQuery));
  }
  return parsedQuery;
}
function getInvalidQueryError(query) {
  return _i18n.i18n.translate('xpack.stackAlerts.esQuery.invalidQueryErrorMessage', {
    defaultMessage: 'invalid query specified: "{query}" - query must be JSON',
    values: {
      query
    }
  });
}