"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleType = getRuleType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _validation = require("./validation");
var _util = require("./util");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const PLUGIN_ID = 'discover';
function getRuleType(alerting) {
  registerNavigation(alerting);
  return {
    id: _ruleDataUtils.ES_QUERY_ID,
    description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.alertType.descriptionText', {
      defaultMessage: 'Alert when matches are found during the latest query run.'
    }),
    iconClass: 'logoElastic',
    documentationUrl: docLinks => docLinks.links.alerting.esQuery,
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./expression')))),
    validate: _validation.validateExpression,
    defaultActionMessage: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.alertType.defaultActionMessage', {
      defaultMessage: `Elasticsearch query rule '\\{\\{rule.name\\}\\}' is active:

- Value: \\{\\{context.value\\}\\}
- Conditions Met: \\{\\{context.conditions\\}\\} over \\{\\{rule.params.timeWindowSize\\}\\}\\{\\{rule.params.timeWindowUnit\\}\\}
- Timestamp: \\{\\{context.date\\}\\}
- Link: \\{\\{context.link\\}\\}`
    }),
    requiresAppContext: false
  };
}
function registerNavigation(alerting) {
  alerting.registerNavigation(PLUGIN_ID, _ruleDataUtils.ES_QUERY_ID, rule => {
    return `/app/discover#/viewAlert/${rule.id}`;
  });
  alerting.registerNavigation(_ruleDataUtils.STACK_ALERTS_FEATURE_ID, _ruleDataUtils.ES_QUERY_ID, rule => {
    if ((0, _util.isSearchSourceRule)(rule.params)) return `/app/discover#/viewAlert/${rule.id}`;
    return;
  });
  alerting.registerNavigation('logs', _ruleDataUtils.ES_QUERY_ID, rule => {
    if ((0, _util.isSearchSourceRule)(rule.params)) return `/app/discover#/viewAlert/${rule.id}`;
    return;
  });
  alerting.registerNavigation('infrastructure', _ruleDataUtils.ES_QUERY_ID, rule => {
    if ((0, _util.isSearchSourceRule)(rule.params)) return `/app/discover#/viewAlert/${rule.id}`;
    return;
  });
  alerting.registerNavigation('observability', _ruleDataUtils.ES_QUERY_ID, rule => {
    if ((0, _util.isSearchSourceRule)(rule.params)) return `/app/discover#/viewAlert/${rule.id}`;
    return;
  });
}