"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigSchema = void 0;
exports.createConfig$ = createConfig$;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.conditional(_configSchema.schema.contextRef('dev'), true, _configSchema.schema.boolean({
    defaultValue: true
  }), _configSchema.schema.boolean({
    validate: rawValue => {
      if (rawValue === false) {
        return 'Spaces can only be disabled in development mode';
      }
    },
    defaultValue: true
  })),
  maxSpaces: _configSchema.schema.number({
    defaultValue: 1000
  }),
  allowFeatureVisibility: (0, _configSchema.offeringBasedSchema)({
    serverless: _configSchema.schema.literal(false),
    traditional: _configSchema.schema.boolean({
      validate: rawValue => {
        // This setting should not be configurable on-prem to avoid bugs when e.g. existing spaces
        // have feature visibility customized but admins would be unable to change them back if the
        // UI/APIs are disabled.
        if (rawValue === false) {
          return 'Feature visibility can only be disabled on serverless';
        }
      },
      defaultValue: true
    })
  })
});
exports.ConfigSchema = ConfigSchema;
function createConfig$(context) {
  return context.config.create();
}