"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageSpacesButton = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ManageSpacesButton extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "navigateToManageSpaces", () => {
      if (this.props.onClick) {
        this.props.onClick();
      }
      this.props.navigateToApp('management', {
        path: 'kibana/spaces'
      });
    });
  }
  render() {
    if (!this.props.capabilities.spaces.manage) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: this.props.size || 's',
      className: this.props.className,
      isDisabled: this.props.isDisabled,
      onClick: this.navigateToManageSpaces,
      style: this.props.style,
      "data-test-subj": "manageSpaces"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.manageSpacesButton.manageSpacesButtonLabel",
      defaultMessage: "Manage spaces"
    }));
  }
}
exports.ManageSpacesButton = ManageSpacesButton;