"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeslicesBudgetingMethodSchema = exports.targetSchema = exports.tagsSchema = exports.sloWithSummarySchema = exports.sloSchema = exports.sloIdSchema = exports.settingsSchema = exports.optionalSettingsSchema = exports.occurrencesBudgetingMethodSchema = exports.objectiveSchema = exports.budgetingMethodSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
var _duration = require("./duration");
var _indicators = require("./indicators");
var _time_window = require("./time_window");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const occurrencesBudgetingMethodSchema = t.literal('occurrences');
exports.occurrencesBudgetingMethodSchema = occurrencesBudgetingMethodSchema;
const timeslicesBudgetingMethodSchema = t.literal('timeslices');
exports.timeslicesBudgetingMethodSchema = timeslicesBudgetingMethodSchema;
const budgetingMethodSchema = t.union([occurrencesBudgetingMethodSchema, timeslicesBudgetingMethodSchema]);
exports.budgetingMethodSchema = budgetingMethodSchema;
const targetSchema = t.type({
  target: t.number
});
exports.targetSchema = targetSchema;
const objectiveSchema = t.intersection([targetSchema, t.partial({
  timesliceTarget: t.number,
  timesliceWindow: _duration.durationType
})]);
exports.objectiveSchema = objectiveSchema;
const settingsSchema = t.type({
  syncDelay: _duration.durationType,
  frequency: _duration.durationType
});
exports.settingsSchema = settingsSchema;
const optionalSettingsSchema = t.partial({
  ...settingsSchema.props
});
exports.optionalSettingsSchema = optionalSettingsSchema;
const tagsSchema = t.array(t.string);
exports.tagsSchema = tagsSchema;
const sloIdSchema = t.string;
exports.sloIdSchema = sloIdSchema;
const sloSchema = t.type({
  id: sloIdSchema,
  name: t.string,
  description: t.string,
  indicator: _indicators.indicatorSchema,
  timeWindow: _time_window.timeWindowSchema,
  budgetingMethod: budgetingMethodSchema,
  objective: objectiveSchema,
  settings: settingsSchema,
  revision: t.number,
  enabled: t.boolean,
  tags: tagsSchema,
  createdAt: _common.dateType,
  updatedAt: _common.dateType,
  groupBy: _common.allOrAnyString,
  version: t.number
});
exports.sloSchema = sloSchema;
const sloWithSummarySchema = t.intersection([sloSchema, t.type({
  summary: _common.summarySchema
})]);
exports.sloWithSummarySchema = sloWithSummarySchema;