"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timesliceMetricPercentileMetric = exports.timesliceMetricMetricDef = exports.timesliceMetricIndicatorTypeSchema = exports.timesliceMetricIndicatorSchema = exports.timesliceMetricDocCountMetric = exports.timesliceMetricComparatorMapping = exports.timesliceMetricBasicMetricWithField = exports.metricCustomIndicatorTypeSchema = exports.metricCustomIndicatorSchema = exports.metricCustomDocCountMetric = exports.metricCustomBasicMetric = exports.kqlCustomIndicatorTypeSchema = exports.kqlCustomIndicatorSchema = exports.indicatorTypesSchema = exports.indicatorTypesArraySchema = exports.indicatorSchema = exports.indicatorDataSchema = exports.histogramIndicatorTypeSchema = exports.histogramIndicatorSchema = exports.apmTransactionErrorRateIndicatorTypeSchema = exports.apmTransactionErrorRateIndicatorSchema = exports.apmTransactionDurationIndicatorTypeSchema = exports.apmTransactionDurationIndicatorSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apmTransactionDurationIndicatorTypeSchema = t.literal('sli.apm.transactionDuration');
exports.apmTransactionDurationIndicatorTypeSchema = apmTransactionDurationIndicatorTypeSchema;
const apmTransactionDurationIndicatorSchema = t.type({
  type: apmTransactionDurationIndicatorTypeSchema,
  params: t.intersection([t.type({
    environment: _common.allOrAnyString,
    service: _common.allOrAnyString,
    transactionType: _common.allOrAnyString,
    transactionName: _common.allOrAnyString,
    threshold: t.number,
    index: t.string
  }), t.partial({
    filter: t.string
  })])
});
exports.apmTransactionDurationIndicatorSchema = apmTransactionDurationIndicatorSchema;
const apmTransactionErrorRateIndicatorTypeSchema = t.literal('sli.apm.transactionErrorRate');
exports.apmTransactionErrorRateIndicatorTypeSchema = apmTransactionErrorRateIndicatorTypeSchema;
const apmTransactionErrorRateIndicatorSchema = t.type({
  type: apmTransactionErrorRateIndicatorTypeSchema,
  params: t.intersection([t.type({
    environment: _common.allOrAnyString,
    service: _common.allOrAnyString,
    transactionType: _common.allOrAnyString,
    transactionName: _common.allOrAnyString,
    index: t.string
  }), t.partial({
    filter: t.string
  })])
});
exports.apmTransactionErrorRateIndicatorSchema = apmTransactionErrorRateIndicatorSchema;
const kqlCustomIndicatorTypeSchema = t.literal('sli.kql.custom');
exports.kqlCustomIndicatorTypeSchema = kqlCustomIndicatorTypeSchema;
const kqlCustomIndicatorSchema = t.type({
  type: kqlCustomIndicatorTypeSchema,
  params: t.intersection([t.type({
    index: t.string,
    good: t.string,
    total: t.string,
    timestampField: t.string
  }), t.partial({
    filter: t.string
  })])
});
exports.kqlCustomIndicatorSchema = kqlCustomIndicatorSchema;
const timesliceMetricComparatorMapping = {
  GT: '>',
  GTE: '>=',
  LT: '<',
  LTE: '<='
};
exports.timesliceMetricComparatorMapping = timesliceMetricComparatorMapping;
const timesliceMetricComparator = t.keyof(timesliceMetricComparatorMapping);
const timesliceMetricBasicMetricWithField = t.intersection([t.type({
  name: t.string,
  aggregation: t.keyof({
    avg: true,
    max: true,
    min: true,
    sum: true,
    cardinality: true,
    last_value: true,
    std_deviation: true
  }),
  field: t.string
}), t.partial({
  filter: t.string
})]);
exports.timesliceMetricBasicMetricWithField = timesliceMetricBasicMetricWithField;
const timesliceMetricDocCountMetric = t.intersection([t.type({
  name: t.string,
  aggregation: t.literal('doc_count')
}), t.partial({
  filter: t.string
})]);
exports.timesliceMetricDocCountMetric = timesliceMetricDocCountMetric;
const timesliceMetricPercentileMetric = t.intersection([t.type({
  name: t.string,
  aggregation: t.literal('percentile'),
  field: t.string,
  percentile: t.number
}), t.partial({
  filter: t.string
})]);
exports.timesliceMetricPercentileMetric = timesliceMetricPercentileMetric;
const timesliceMetricMetricDef = t.union([timesliceMetricBasicMetricWithField, timesliceMetricDocCountMetric, timesliceMetricPercentileMetric]);
exports.timesliceMetricMetricDef = timesliceMetricMetricDef;
const timesliceMetricDef = t.type({
  metrics: t.array(timesliceMetricMetricDef),
  equation: t.string,
  threshold: t.number,
  comparator: timesliceMetricComparator
});
const timesliceMetricIndicatorTypeSchema = t.literal('sli.metric.timeslice');
exports.timesliceMetricIndicatorTypeSchema = timesliceMetricIndicatorTypeSchema;
const timesliceMetricIndicatorSchema = t.type({
  type: timesliceMetricIndicatorTypeSchema,
  params: t.intersection([t.type({
    index: t.string,
    metric: timesliceMetricDef,
    timestampField: t.string
  }), t.partial({
    filter: t.string
  })])
});
exports.timesliceMetricIndicatorSchema = timesliceMetricIndicatorSchema;
const metricCustomDocCountMetric = t.intersection([t.type({
  name: t.string,
  aggregation: t.literal('doc_count')
}), t.partial({
  filter: t.string
})]);
exports.metricCustomDocCountMetric = metricCustomDocCountMetric;
const metricCustomBasicMetric = t.intersection([t.type({
  name: t.string,
  aggregation: t.literal('sum'),
  field: t.string
}), t.partial({
  filter: t.string
})]);
exports.metricCustomBasicMetric = metricCustomBasicMetric;
const metricCustomMetricDef = t.type({
  metrics: t.array(t.union([metricCustomBasicMetric, metricCustomDocCountMetric])),
  equation: t.string
});
const metricCustomIndicatorTypeSchema = t.literal('sli.metric.custom');
exports.metricCustomIndicatorTypeSchema = metricCustomIndicatorTypeSchema;
const metricCustomIndicatorSchema = t.type({
  type: metricCustomIndicatorTypeSchema,
  params: t.intersection([t.type({
    index: t.string,
    good: metricCustomMetricDef,
    total: metricCustomMetricDef,
    timestampField: t.string
  }), t.partial({
    filter: t.string
  })])
});
exports.metricCustomIndicatorSchema = metricCustomIndicatorSchema;
const rangeHistogramMetricType = t.literal('range');
const rangeBasedHistogramMetricDef = t.intersection([t.type({
  field: t.string,
  aggregation: rangeHistogramMetricType,
  from: t.number,
  to: t.number
}), t.partial({
  filter: t.string
})]);
const valueCountHistogramMetricType = t.literal('value_count');
const valueCountBasedHistogramMetricDef = t.intersection([t.type({
  field: t.string,
  aggregation: valueCountHistogramMetricType
}), t.partial({
  filter: t.string
})]);
const histogramMetricDef = t.union([valueCountBasedHistogramMetricDef, rangeBasedHistogramMetricDef]);
const histogramIndicatorTypeSchema = t.literal('sli.histogram.custom');
exports.histogramIndicatorTypeSchema = histogramIndicatorTypeSchema;
const histogramIndicatorSchema = t.type({
  type: histogramIndicatorTypeSchema,
  params: t.intersection([t.type({
    index: t.string,
    timestampField: t.string,
    good: histogramMetricDef,
    total: histogramMetricDef
  }), t.partial({
    filter: t.string
  })])
});
exports.histogramIndicatorSchema = histogramIndicatorSchema;
const indicatorDataSchema = t.type({
  dateRange: _common.dateRangeSchema,
  good: t.number,
  total: t.number
});
exports.indicatorDataSchema = indicatorDataSchema;
const indicatorTypesSchema = t.union([apmTransactionDurationIndicatorTypeSchema, apmTransactionErrorRateIndicatorTypeSchema, kqlCustomIndicatorTypeSchema, metricCustomIndicatorTypeSchema, timesliceMetricIndicatorTypeSchema, histogramIndicatorTypeSchema]);

// Validate that a string is a comma separated list of indicator types,
// e.g. sli.kql.custom,sli.apm.transactionDuration
// Transform to an array of indicator type
exports.indicatorTypesSchema = indicatorTypesSchema;
const indicatorTypesArraySchema = new t.Type('indicatorTypesArray', input => Array.isArray(input) && input.every(i => typeof i === 'string'), (input, context) => {
  if (typeof input === 'string') {
    const values = input.split(',');
    if (values.every(value => typeof value === 'string' && indicatorTypesSchema.is(value))) {
      return t.success(values);
    }
  }
  return t.failure(input, context);
}, values => values.join(','));
exports.indicatorTypesArraySchema = indicatorTypesArraySchema;
const indicatorSchema = t.union([apmTransactionDurationIndicatorSchema, apmTransactionErrorRateIndicatorSchema, kqlCustomIndicatorSchema, metricCustomIndicatorSchema, timesliceMetricIndicatorSchema, histogramIndicatorSchema]);
exports.indicatorSchema = indicatorSchema;