"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSLOResponseSchema = exports.updateSLOParamsSchema = exports.sloWithSummaryResponseSchema = exports.sloResponseSchema = exports.resetSLOResponseSchema = exports.resetSLOParamsSchema = exports.manageSLOParamsSchema = exports.getSLOResponseSchema = exports.getSLOParamsSchema = exports.getSLOInstancesResponseSchema = exports.getSLOInstancesParamsSchema = exports.getSLOBurnRatesResponseSchema = exports.getSLOBurnRatesParamsSchema = exports.getPreviewDataResponseSchema = exports.getPreviewDataParamsSchema = exports.findSloDefinitionsResponseSchema = exports.findSloDefinitionsParamsSchema = exports.findSLOResponseSchema = exports.findSLOParamsSchema = exports.fetchHistoricalSummaryResponseSchema = exports.fetchHistoricalSummaryParamsSchema = exports.deleteSLOParamsSchema = exports.deleteSLOInstancesParamsSchema = exports.createSLOParamsSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _schema = require("../schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSLOParamsSchema = t.type({
  body: t.intersection([t.type({
    name: t.string,
    description: t.string,
    indicator: _schema.indicatorSchema,
    timeWindow: _schema.timeWindowSchema,
    budgetingMethod: _schema.budgetingMethodSchema,
    objective: _schema.objectiveSchema
  }), t.partial({
    id: _schema.sloIdSchema,
    settings: _schema.optionalSettingsSchema,
    tags: _schema.tagsSchema,
    groupBy: _schema.allOrAnyString
  })])
});
exports.createSLOParamsSchema = createSLOParamsSchema;
const createSLOResponseSchema = t.type({
  id: _schema.sloIdSchema
});
const getPreviewDataParamsSchema = t.type({
  body: t.type({
    indicator: _schema.indicatorSchema,
    range: t.type({
      start: t.number,
      end: t.number
    })
  })
});
exports.getPreviewDataParamsSchema = getPreviewDataParamsSchema;
const getPreviewDataResponseSchema = t.array(_schema.previewDataSchema);
exports.getPreviewDataResponseSchema = getPreviewDataResponseSchema;
const deleteSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.sloIdSchema
  })
});
exports.deleteSLOParamsSchema = deleteSLOParamsSchema;
const sortDirectionSchema = t.union([t.literal('asc'), t.literal('desc')]);
const sortBySchema = t.union([t.literal('error_budget_consumed'), t.literal('error_budget_remaining'), t.literal('sli_value'), t.literal('status')]);
const findSLOParamsSchema = t.partial({
  query: t.partial({
    kqlQuery: t.string,
    page: t.string,
    perPage: t.string,
    sortBy: sortBySchema,
    sortDirection: sortDirectionSchema
  })
});
exports.findSLOParamsSchema = findSLOParamsSchema;
const sloResponseSchema = t.intersection([t.type({
  id: _schema.sloIdSchema,
  name: t.string,
  description: t.string,
  indicator: _schema.indicatorSchema,
  timeWindow: _schema.timeWindowSchema,
  budgetingMethod: _schema.budgetingMethodSchema,
  objective: _schema.objectiveSchema,
  revision: t.number,
  settings: _schema.settingsSchema,
  enabled: t.boolean,
  tags: _schema.tagsSchema,
  groupBy: _schema.allOrAnyString,
  createdAt: _schema.dateType,
  updatedAt: _schema.dateType,
  version: t.number
}), t.partial({
  instanceId: _schema.allOrAnyString
})]);
exports.sloResponseSchema = sloResponseSchema;
const sloWithSummaryResponseSchema = t.intersection([sloResponseSchema, t.type({
  summary: _schema.summarySchema
})]);
exports.sloWithSummaryResponseSchema = sloWithSummaryResponseSchema;
const getSLOQuerySchema = t.partial({
  query: t.partial({
    instanceId: _schema.allOrAnyString
  })
});
const getSLOParamsSchema = t.intersection([t.type({
  path: t.type({
    id: _schema.sloIdSchema
  })
}), getSLOQuerySchema]);
exports.getSLOParamsSchema = getSLOParamsSchema;
const getSLOResponseSchema = sloWithSummaryResponseSchema;
exports.getSLOResponseSchema = getSLOResponseSchema;
const updateSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.sloIdSchema
  }),
  body: t.partial({
    name: t.string,
    description: t.string,
    indicator: _schema.indicatorSchema,
    timeWindow: _schema.timeWindowSchema,
    budgetingMethod: _schema.budgetingMethodSchema,
    objective: _schema.objectiveSchema,
    settings: _schema.optionalSettingsSchema,
    tags: _schema.tagsSchema,
    groupBy: _schema.allOrAnyString
  })
});
exports.updateSLOParamsSchema = updateSLOParamsSchema;
const manageSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.sloIdSchema
  })
});
exports.manageSLOParamsSchema = manageSLOParamsSchema;
const resetSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.sloIdSchema
  })
});
exports.resetSLOParamsSchema = resetSLOParamsSchema;
const resetSLOResponseSchema = sloResponseSchema;
exports.resetSLOResponseSchema = resetSLOResponseSchema;
const updateSLOResponseSchema = sloResponseSchema;
exports.updateSLOResponseSchema = updateSLOResponseSchema;
const findSLOResponseSchema = t.type({
  page: t.number,
  perPage: t.number,
  total: t.number,
  results: t.array(sloWithSummaryResponseSchema)
});
exports.findSLOResponseSchema = findSLOResponseSchema;
const deleteSLOInstancesParamsSchema = t.type({
  body: t.type({
    list: t.array(t.type({
      sloId: _schema.sloIdSchema,
      instanceId: t.string
    }))
  })
});
exports.deleteSLOInstancesParamsSchema = deleteSLOInstancesParamsSchema;
const fetchHistoricalSummaryParamsSchema = t.type({
  body: t.type({
    list: t.array(t.type({
      sloId: _schema.sloIdSchema,
      instanceId: _schema.allOrAnyString
    }))
  })
});
exports.fetchHistoricalSummaryParamsSchema = fetchHistoricalSummaryParamsSchema;
const fetchHistoricalSummaryResponseSchema = t.array(t.type({
  sloId: _schema.sloIdSchema,
  instanceId: _schema.allOrAnyString,
  data: t.array(_schema.historicalSummarySchema)
}));
exports.fetchHistoricalSummaryResponseSchema = fetchHistoricalSummaryResponseSchema;
const findSloDefinitionsParamsSchema = t.partial({
  query: t.partial({
    search: t.string,
    includeOutdatedOnly: _ioTsUtils.toBooleanRt,
    page: t.string,
    perPage: t.string
  })
});
exports.findSloDefinitionsParamsSchema = findSloDefinitionsParamsSchema;
const findSloDefinitionsResponseSchema = t.type({
  page: t.number,
  perPage: t.number,
  total: t.number,
  results: t.array(sloResponseSchema)
});
exports.findSloDefinitionsResponseSchema = findSloDefinitionsResponseSchema;
const getSLOBurnRatesResponseSchema = t.type({
  burnRates: t.array(t.type({
    name: t.string,
    burnRate: t.number,
    sli: t.number
  }))
});
exports.getSLOBurnRatesResponseSchema = getSLOBurnRatesResponseSchema;
const getSLOBurnRatesParamsSchema = t.type({
  path: t.type({
    id: t.string
  }),
  body: t.type({
    instanceId: _schema.allOrAnyString,
    windows: t.array(t.type({
      name: t.string,
      duration: _schema.durationType
    }))
  })
});
exports.getSLOBurnRatesParamsSchema = getSLOBurnRatesParamsSchema;
const getSLOInstancesParamsSchema = t.type({
  path: t.type({
    id: t.string
  })
});
exports.getSLOInstancesParamsSchema = getSLOInstancesParamsSchema;
const getSLOInstancesResponseSchema = t.type({
  groupBy: t.string,
  instances: t.array(t.string)
});

// Raw payload sent by the frontend
// Parsed payload used by the backend
// Raw response sent to the frontend
exports.getSLOInstancesResponseSchema = getSLOInstancesResponseSchema;