"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TTYPlayerLineMarkerType = exports.TTYPlayerControlsMarkers = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _play_head = require("./play_head");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TTYPlayerLineMarkerType;
exports.TTYPlayerLineMarkerType = TTYPlayerLineMarkerType;
(function (TTYPlayerLineMarkerType) {
  TTYPlayerLineMarkerType["ProcessChanged"] = "process_changed";
  TTYPlayerLineMarkerType["ProcessDataLimitReached"] = "data_limited";
})(TTYPlayerLineMarkerType || (exports.TTYPlayerLineMarkerType = TTYPlayerLineMarkerType = {}));
const TTYPlayerControlsMarkers = ({
  processStartMarkers,
  linesLength,
  currentLine,
  onChange,
  onSeekLine
}) => {
  const progress = (0, _react.useMemo)(() => currentLine / (linesLength - 1) * 100, [currentLine, linesLength]);
  const styles = (0, _styles.useStyles)(progress);
  const markers = (0, _react.useMemo)(() => {
    if (processStartMarkers.length < 1) {
      return [];
    }
    return processStartMarkers.map(({
      event,
      line,
      maxBytesExceeded
    }) => {
      var _event$process;
      return {
        type: maxBytesExceeded ? TTYPlayerLineMarkerType.ProcessDataLimitReached : TTYPlayerLineMarkerType.ProcessChanged,
        line,
        name: (_event$process = event.process) === null || _event$process === void 0 ? void 0 : _event$process.name
      };
    });
  }, [processStartMarkers]);
  const markersLength = markers.length;
  const currentSelectedType = (0, _react.useMemo)(() => {
    if (!markersLength) {
      return undefined;
    }
    const currentSelected = currentLine >= markers[markersLength - 1].line ? markersLength - 1 : markers.findIndex(marker => marker.line > currentLine) - 1;
    return markers[Math.max(0, currentSelected)].type;
  }, [currentLine, markers, markersLength]);
  if (!markersLength) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    value: currentLine,
    min: 0,
    max: Math.max(0, linesLength - 1),
    onChange: onChange,
    fullWidth: true,
    showRange: true,
    css: styles.range
  }), /*#__PURE__*/_react.default.createElement(_play_head.PlayHead, {
    css: styles.playHead(currentSelectedType)
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.markersOverlay
  }, markers.map(({
    line,
    type,
    name
  }, idx) => {
    const selected = currentLine >= line && (idx === markersLength - 1 || currentLine < markers[idx + 1].line);

    // markers positions are absolute, setting higher z-index on the selected one in case there
    // are severals next to each other
    const markerWrapperPositioning = {
      left: `${line / (linesLength - 1) * 100}%`,
      zIndex: selected ? 3 : 2
    };
    const onMarkerClick = () => onSeekLine(line);
    return /*#__PURE__*/_react.default.createElement("div", {
      key: idx,
      style: markerWrapperPositioning,
      css: styles.markerWrapper
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: name
    }, /*#__PURE__*/_react.default.createElement("button", {
      type: "button",
      value: line,
      tabIndex: -1,
      title: type,
      css: styles.marker(type, selected),
      onClick: onMarkerClick,
      "aria-label": name
    }, name)));
  })));
};
exports.TTYPlayerControlsMarkers = TTYPlayerControlsMarkers;