"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.versionOrUndefined = exports.version = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _positive_integer_greater_than_zero = require("../positive_integer_greater_than_zero");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Note this is just a positive number, but we use it as a type here which is still ok.
 * This type was originally from "x-pack/plugins/security_solution/common/detection_engine/schemas/common/schemas.ts"
 * but is moved here to make things more portable. No unit tests, but see PositiveIntegerGreaterThanZero integer for unit tests.
 */
const version = _positive_integer_greater_than_zero.PositiveIntegerGreaterThanZero;
exports.version = version;
const versionOrUndefined = t.union([version, t.undefined]);
exports.versionOrUndefined = versionOrUndefined;