"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionUuid = exports.RuleActionTypeId = exports.RuleActionParams = exports.RuleActionId = exports.RuleActionGroup = exports.RuleActionCamel = exports.RuleActionArrayCamel = exports.RuleActionArray = exports.RuleActionAlertsFilter = exports.RuleAction = void 0;
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var t = _interopRequireWildcard(require("io-ts"));
var _saved_object_attributes = require("../saved_object_attributes");
var _frequency = require("../frequency");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RuleActionGroup = t.string;
exports.RuleActionGroup = RuleActionGroup;
const RuleActionId = t.string;
exports.RuleActionId = RuleActionId;
const RuleActionTypeId = t.string;
exports.RuleActionTypeId = RuleActionTypeId;
const RuleActionUuid = _securitysolutionIoTsTypes.NonEmptyString;

/**
 * Params is an "object", since it is a type of RuleActionParams which is action templates.
 * @see x-pack/plugins/alerting/common/rule.ts
 */
exports.RuleActionUuid = RuleActionUuid;
const RuleActionParams = _saved_object_attributes.saved_object_attributes;
exports.RuleActionParams = RuleActionParams;
const RuleActionAlertsFilter = t.partial({
  query: t.union([t.undefined, t.intersection([t.strict({
    kql: t.string,
    filters: t.array(t.intersection([t.type({
      meta: t.partial({
        alias: t.union([t.string, t.null]),
        disabled: t.boolean,
        negate: t.boolean,
        controlledBy: t.string,
        group: t.string,
        index: t.string,
        isMultiIndex: t.boolean,
        type: t.string,
        key: t.string,
        params: t.any,
        value: t.string
      })
    }), t.partial({
      $state: t.type({
        store: t.any
      }),
      query: t.record(t.string, t.any)
    })]))
  }), t.partial({
    dsl: t.string
  })])]),
  timeframe: t.union([t.undefined, t.strict({
    timezone: t.string,
    days: t.array(t.union([t.literal(1), t.literal(2), t.literal(3), t.literal(4), t.literal(5), t.literal(6), t.literal(7)])),
    hours: t.strict({
      start: t.string,
      end: t.string
    })
  })])
});
exports.RuleActionAlertsFilter = RuleActionAlertsFilter;
const RuleAction = t.exact(t.intersection([t.type({
  group: RuleActionGroup,
  id: RuleActionId,
  action_type_id: RuleActionTypeId,
  params: RuleActionParams
}), t.partial({
  uuid: RuleActionUuid,
  alerts_filter: RuleActionAlertsFilter,
  frequency: _frequency.RuleActionFrequency
})]));
exports.RuleAction = RuleAction;
const RuleActionArray = t.array(RuleAction);
exports.RuleActionArray = RuleActionArray;
const RuleActionCamel = t.exact(t.intersection([t.type({
  group: RuleActionGroup,
  id: RuleActionId,
  actionTypeId: RuleActionTypeId,
  params: RuleActionParams
}), t.partial({
  uuid: RuleActionUuid,
  alertsFilter: RuleActionAlertsFilter,
  frequency: _frequency.RuleActionFrequency
})]));
exports.RuleActionCamel = RuleActionCamel;
const RuleActionArrayCamel = t.array(RuleActionCamel);
exports.RuleActionArrayCamel = RuleActionArrayCamel;