"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavigationFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _util = require("../links/util");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SideNavigationFooter = ({
  activeNodeId,
  items,
  categories
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, categories.map((category, index) => {
    var _category$linkIds$red, _category$linkIds;
    const categoryItems = (_category$linkIds$red = (_category$linkIds = category.linkIds) === null || _category$linkIds === void 0 ? void 0 : _category$linkIds.reduce((acc, linkId) => {
      const item = items.find(({
        id
      }) => id === linkId);
      if (item) {
        acc.push(item);
      }
      return acc;
    }, [])) !== null && _category$linkIds$red !== void 0 ? _category$linkIds$red : [];
    if ((0, _securitySolutionNavigation.isSeparatorLinkCategory)(category)) {
      return /*#__PURE__*/_react.default.createElement(SideNavigationFooterStandalone, {
        key: index,
        items: categoryItems,
        activeNodeId: activeNodeId
      });
    }
    if ((0, _securitySolutionNavigation.isAccordionLinkCategory)(category)) {
      var _category$label;
      return /*#__PURE__*/_react.default.createElement(SideNavigationFooterCollapsible, {
        key: index,
        title: (_category$label = category.label) !== null && _category$label !== void 0 ? _category$label : '',
        items: categoryItems,
        activeNodeId: activeNodeId,
        icon: category.iconType
      });
    }
    return null;
  }));
};
exports.SideNavigationFooter = SideNavigationFooter;
const SideNavigationFooterStandalone = ({
  items,
  activeNodeId
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavItem, {
  key: item.id,
  id: item.id,
  title: item.label,
  icon: item.iconType,
  iconProps: {
    size: 'm'
  },
  "data-test-subj": `solutionSideNavItemLink-${item.id}`,
  href: item.href,
  onClick: item.onClick,
  isSelected: (0, _util.getNavLinkIdFromProjectPageName)(item.id) === activeNodeId,
  linkProps: {
    external: item.openInNewTab
  }
})));
const SideNavigationFooterCollapsible = ({
  title,
  icon,
  items,
  activeNodeId
}) => {
  const hasSelected = (0, _react.useMemo)(() => items.some(({
    id
  }) => (0, _util.getNavLinkIdFromProjectPageName)(id) === activeNodeId), [activeNodeId, items]);
  const [isOpen, setIsOpen] = (0, _react.useState)(hasSelected);
  const categoryId = (0, _react.useMemo)(() => (title !== null && title !== void 0 ? title : '').toLowerCase().replace(' ', '-'), [title]);
  (0, _react.useEffect)(() => {
    setIsOpen(open => !open ? hasSelected : true);
  }, [hasSelected]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavItem, {
    key: categoryId,
    "data-test-subj": `navFooterCollapsible-${categoryId}`,
    title: title,
    icon: icon,
    iconProps: {
      size: 'm'
    },
    accordionProps: {
      forceState: isOpen ? 'open' : 'closed',
      initialIsOpen: isOpen,
      onToggle: open => {
        setIsOpen(open);
      }
    },
    items: items.map(item => formatCollapsibleItem(item, activeNodeId))
  });
};
const formatCollapsibleItem = (sideNavItem, activeNodeId) => {
  return {
    'data-test-subj': `solutionSideNavItemLink-${sideNavItem.id}`,
    id: sideNavItem.id,
    title: sideNavItem.label,
    isSelected: (0, _util.getNavLinkIdFromProjectPageName)(sideNavItem.id) === activeNodeId,
    href: sideNavItem.href,
    ...(sideNavItem.openInNewTab && {
      target: '_blank'
    }),
    onClick: sideNavItem.onClick,
    icon: sideNavItem.iconType,
    iconProps: {
      size: 's'
    }
  };
};