"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.investigationsNavLinks = exports.createInvestigationsLinkFromTimeline = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _common = require("@kbn/security-solution-plugin/common");
var _constants = require("../constants");
var _lazy_icons = require("../../../common/lazy_icons");
var i18n = _interopRequireWildcard(require("./investigations_translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// appLinks configures the Security Solution pages links
const investigationsAppLink = {
  id: _securitySolutionNavigation.SecurityPageName.investigations,
  title: i18n.INVESTIGATIONS_TITLE,
  path: _constants.SecurityPagePath[_securitySolutionNavigation.SecurityPageName.investigations],
  capabilities: [`${_common.SERVER_APP_ID}.show`],
  hideTimeline: true,
  skipUrlState: true,
  links: [] // timeline link are added in createInvestigationsLinkFromTimeline
};

const createInvestigationsLinkFromTimeline = timelineLink => {
  return {
    ...investigationsAppLink,
    links: [{
      ...timelineLink,
      description: i18n.TIMELINE_DESCRIPTION,
      landingIcon: _lazy_icons.IconTimelineLazy
    }]
  };
};

// navLinks define the navigation links for the Security Solution pages and External pages as well
exports.createInvestigationsLinkFromTimeline = createInvestigationsLinkFromTimeline;
const investigationsNavLinks = [{
  id: _constants.ExternalPageName.osquery,
  title: i18n.OSQUERY_TITLE,
  landingIcon: _lazy_icons.IconOsqueryLazy,
  description: i18n.OSQUERY_DESCRIPTION
}];
exports.investigationsNavLinks = investigationsNavLinks;