"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TogglePanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_setup_sections = require("./hooks/use_setup_sections");
var _step_context = require("./context/step_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TogglePanelComponent = ({
  activeSections,
  activeProducts
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    expandedCardSteps,
    finishedSteps,
    toggleTaskCompleteStatus,
    onStepClicked
  } = (0, _step_context.useStepContext)();
  const {
    setUpSections
  } = (0, _use_setup_sections.useSetUpSections)({
    euiTheme
  });
  const sectionNodes = setUpSections({
    activeSections,
    expandedCardSteps,
    finishedSteps,
    toggleTaskCompleteStatus,
    onStepClicked
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, activeProducts.size > 0 ? sectionNodes : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "magnifyWithExclamation",
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.TOGGLE_PANEL_EMPTY_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, i18n.TOGGLE_PANEL_EMPTY_DESCRIPTION),
    css: (0, _react2.css)`
              padding: ${euiTheme.base * 5}px 0;
              .euiEmptyPrompt__contentInner {
                max-width: none;
              }
            `
  })));
};
const TogglePanel = /*#__PURE__*/_react.default.memo(TogglePanelComponent);
exports.TogglePanel = TogglePanel;