"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCardItemStyles = exports.SHADOW_ANIMATION_DURATION = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHADOW_ANIMATION_DURATION = 350;
exports.SHADOW_ANIMATION_DURATION = SHADOW_ANIMATION_DURATION;
const useCardItemStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const shadow = (0, _eui.useEuiShadow)('l');
  return (0, _react.css)`
    &.card-item {
      padding: ${euiTheme.size.base};
      border-radius: ${euiTheme.size.s};
      border: 1px solid ${euiTheme.colors.lightShade};
      box-sizing: content-box;

      &:hover,
      &.card-expanded {
        ${shadow};
        transition: box-shadow ${SHADOW_ANIMATION_DURATION}ms ease-out;
      }

      &.card-expanded {
        border: 2px solid #6092c0;
      }
    }
  `;
};
exports.useCardItemStyles = useCardItemStyles;