"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsButton = void 0;
var _links = require("@kbn/security-solution-navigation/links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _react = _interopRequireWildcard(require("react"));
var _step_context = require("../context/step_context");
var _types = require("../types");
var _add_integration_callout = require("./add_integration_callout");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsButtonComponent = () => {
  var _finishedSteps$AddAnd;
  const {
    toggleTaskCompleteStatus,
    finishedSteps
  } = (0, _step_context.useStepContext)();
  const isIntegrationsStepComplete = (_finishedSteps$AddAnd = finishedSteps[_types.AddAndValidateYourDataCardsId.addIntegrations]) === null || _finishedSteps$AddAnd === void 0 ? void 0 : _finishedSteps$AddAnd.has(_types.AddIntegrationsSteps.connectToDataSources);
  const onClick = (0, _react.useCallback)(() => {
    toggleTaskCompleteStatus({
      stepId: _types.ViewAlertsSteps.viewAlerts,
      cardId: _types.GetStartedWithAlertsCardsId.viewAlerts,
      sectionId: _types.SectionId.getStartedWithAlerts,
      undo: false
    });
  }, [toggleTaskCompleteStatus]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isIntegrationsStepComplete && /*#__PURE__*/_react.default.createElement(_add_integration_callout.AddIntegrationCallout, {
    stepName: _translations.VIEW_ALERTS_CALLOUT_TITLE
  }), /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    className: "step-paragraph",
    disabled: !isIntegrationsStepComplete,
    fill: true,
    id: _securitySolutionNavigation.SecurityPageName.alerts,
    onClick: onClick
  }, _translations.VIEW_ALERTS));
};
const AlertsButton = /*#__PURE__*/_react.default.memo(AlertsButtonComponent);
exports.AlertsButton = AlertsButton;