"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _footer = require("../styles/footer.styles");
var _footer2 = require("./footer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FooterComponent = () => {
  const {
    wrapperStyle,
    titleStyle,
    descriptionStyle,
    linkStyle
  } = (0, _footer.useFooterStyles)();
  const footer = (0, _react.useMemo)(() => (0, _footer2.getFooter)(), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    css: wrapperStyle
  }, footer.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `footer-${item.key}`
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: item.icon,
    alt: item.title,
    height: "64",
    width: "64"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("p", {
    css: titleStyle
  }, item.title), /*#__PURE__*/_react.default.createElement("p", {
    css: descriptionStyle
  }, item.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: item.link.href,
    external: true,
    target: "_blank",
    css: linkStyle
  }, item.link.title))));
};
const Footer = /*#__PURE__*/_react.default.memo(FooterComponent);
exports.Footer = Footer;