"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Video = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _step_context = require("../../context/step_context");
var _translations = require("../../translations");
var _types = require("../../types");
var _content_wrapper = require("./content_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VideoComponent = () => {
  const {
    toggleTaskCompleteStatus,
    finishedSteps
  } = (0, _step_context.useStepContext)();
  const ref = _react2.default.useRef(null);
  const [isVideoPlaying, setIsVideoPlaying] = _react2.default.useState(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cardId = _types.QuickStartSectionCardsId.watchTheOverviewVideo;
  const isFinishedStep = (0, _react2.useMemo)(() => {
    var _finishedSteps$cardId;
    return (_finishedSteps$cardId = finishedSteps[cardId]) === null || _finishedSteps$cardId === void 0 ? void 0 : _finishedSteps$cardId.has(_types.OverviewSteps.getToKnowElasticSecurity);
  }, [finishedSteps, cardId]);
  const onVideoClicked = (0, _react2.useCallback)(() => {
    toggleTaskCompleteStatus({
      stepId: _types.OverviewSteps.getToKnowElasticSecurity,
      cardId: _types.QuickStartSectionCardsId.watchTheOverviewVideo,
      sectionId: _types.SectionId.quickStart,
      undo: false
    });
    setIsVideoPlaying(true);
  }, [toggleTaskCompleteStatus]);
  return /*#__PURE__*/_react2.default.createElement(_content_wrapper.ContentWrapper, null, /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, !isVideoPlaying && !isFinishedStep && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
              background-color: ${euiTheme.colors.fullShade};
              height: 100%;
              width: 100%;
              position: absolute;
              z-index: 1;
              cursor: pointer;
            `,
    gutterSize: "none",
    justifyContent: "center",
    alignItems: "center",
    onClick: onVideoClicked
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "playFilled",
    size: "xxl",
    color: euiTheme.colors.emptyShade
  }))), (isVideoPlaying || isFinishedStep) && /*#__PURE__*/_react2.default.createElement("iframe", {
    ref: ref,
    allowFullScreen: true,
    className: "vidyard_iframe",
    frameBorder: "0",
    height: "100%",
    width: "100%",
    referrerPolicy: "no-referrer",
    sandbox: "allow-scripts allow-same-origin",
    scrolling: "no",
    allow: isVideoPlaying ? 'autoplay;' : undefined,
    src: `//play.vidyard.com/K6kKDBbP9SpXife9s2tHNP.html${isVideoPlaying ? '?autoplay=1' : ''}`,
    title: _translations.WATCH_VIDEO_BUTTON_TITLE
  })));
};
const Video = /*#__PURE__*/_react2.default.memo(VideoComponent);
exports.Video = Video;