"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _helpers = require("./helpers");
var _card_step = require("./card_step");
var _card_item = require("./styles/card_item.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CardItemComponent = ({
  activeStepIds,
  cardId,
  expandedCardSteps,
  finishedSteps,
  toggleTaskCompleteStatus,
  onStepClicked,
  sectionId
}) => {
  const isExpandedCard = expandedCardSteps[cardId].isExpanded;
  const cardItem = (0, _react.useMemo)(() => (0, _helpers.getCard)({
    cardId,
    sectionId
  }), [cardId, sectionId]);
  const expandedSteps = (0, _react.useMemo)(() => {
    var _expandedCardSteps$ca, _expandedCardSteps$ca2;
    return new Set((_expandedCardSteps$ca = (_expandedCardSteps$ca2 = expandedCardSteps[cardId]) === null || _expandedCardSteps$ca2 === void 0 ? void 0 : _expandedCardSteps$ca2.expandedSteps) !== null && _expandedCardSteps$ca !== void 0 ? _expandedCardSteps$ca : []);
  }, [cardId, expandedCardSteps]);
  const cardClassNames = (0, _classnames.default)('card-item', {
    'card-expanded': isExpandedCard
  });
  const cardItemPanelStyle = (0, _card_item.useCardItemStyles)();
  const getCardStep = (0, _react.useCallback)(stepId => {
    var _cardItem$steps;
    return cardItem === null || cardItem === void 0 ? void 0 : (_cardItem$steps = cardItem.steps) === null || _cardItem$steps === void 0 ? void 0 : _cardItem$steps.find(step => step.id === stepId);
  }, [cardItem === null || cardItem === void 0 ? void 0 : cardItem.steps]);
  const steps = (0, _react.useMemo)(() => activeStepIds === null || activeStepIds === void 0 ? void 0 : activeStepIds.reduce((acc, stepId) => {
    const step = getCardStep(stepId);
    if (step && cardItem) {
      acc.push( /*#__PURE__*/_react.default.createElement(_card_step.CardStep, {
        cardId: cardItem.id,
        expandedSteps: expandedSteps,
        finishedSteps: finishedSteps,
        key: stepId,
        toggleTaskCompleteStatus: toggleTaskCompleteStatus,
        onStepClicked: onStepClicked,
        sectionId: sectionId,
        step: step
      }));
    }
    return acc;
  }, []), [activeStepIds, cardItem, expandedSteps, finishedSteps, getCardStep, onStepClicked, sectionId, toggleTaskCompleteStatus]);
  return cardItem && activeStepIds ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: cardClassNames,
    hasBorder: true,
    paddingSize: "none",
    css: cardItemPanelStyle,
    borderRadius: "none",
    "data-test-subj": cardId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, steps))) : null;
};
CardItemComponent.displayName = 'CardItemComponent';
const CardItem = /*#__PURE__*/_react.default.memo(CardItemComponent);
exports.CardItem = CardItem;