"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProductAppFeatures = void 0;
var _product = require("../product");
var _pli_config = require("./pli_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the U (union) of all PLIs from the enabled productTypes in a single array.
 */
const getProductAppFeatures = productTypes => {
  const appFeatureKeys = productTypes.reduce((appFeatures, {
    product_line: line,
    product_tier: tier
  }) => {
    if (tier === _product.ProductTier.complete) {
      appFeatures.push(..._pli_config.PLI_APP_FEATURES[line][_product.ProductTier.essentials]);
    }
    appFeatures.push(..._pli_config.PLI_APP_FEATURES[line][tier]);
    return appFeatures;
  }, []);
  return appFeatureKeys;
};
exports.getProductAppFeatures = getProductAppFeatures;