"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTelemetryDiagnosticTimelineTaskConfig = createTelemetryDiagnosticTimelineTaskConfig;
var _constants = require("../constants");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTelemetryDiagnosticTimelineTaskConfig() {
  const taskName = 'Security Solution Diagnostic Timeline telemetry';
  return {
    type: 'security:telemetry-diagnostic-timelines',
    title: taskName,
    interval: '1h',
    timeout: '15m',
    version: '1.0.0',
    runTask: async (taskId, logger, receiver, sender, taskExecutionPeriod) => {
      (0, _helpers.tlog)(logger, `Running task: ${taskId} [last: ${taskExecutionPeriod.last} - current: ${taskExecutionPeriod.current}]`);
      const fetcher = new _helpers.TelemetryTimelineFetcher(receiver);
      try {
        let counter = 0;
        const {
          rangeFrom,
          rangeTo
        } = (0, _helpers.ranges)(taskExecutionPeriod);
        const alerts = await receiver.fetchTimelineAlerts(_constants.DEFAULT_DIAGNOSTIC_INDEX, rangeFrom, rangeTo);
        (0, _helpers.tlog)(logger, `found ${alerts.length} alerts to process`);
        for (const alert of alerts) {
          var _sender$getTelemetryU, _sender$getTelemetryU2;
          const result = await fetcher.fetchTimeline(alert);
          (_sender$getTelemetryU = sender.getTelemetryUsageCluster()) === null || _sender$getTelemetryU === void 0 ? void 0 : _sender$getTelemetryU.incrementCounter({
            counterName: 'telemetry_timeline_diagnostic',
            counterType: 'timeline_diagnostic_node_count',
            incrementBy: result.nodes
          });
          (_sender$getTelemetryU2 = sender.getTelemetryUsageCluster()) === null || _sender$getTelemetryU2 === void 0 ? void 0 : _sender$getTelemetryU2.incrementCounter({
            counterName: 'telemetry_timeline_diagnostic',
            counterType: 'timeline_diagnostic_event_count',
            incrementBy: result.events
          });
          if (result.timeline) {
            sender.sendOnDemand(_constants.TELEMETRY_CHANNEL_TIMELINE, [result.timeline]);
            counter += 1;
          } else {
            (0, _helpers.tlog)(logger, 'no events in timeline');
          }
        }
        (0, _helpers.tlog)(logger, `sent ${counter} timelines. Concluding timeline task.`);
        await sender.sendOnDemand(_constants.TASK_METRICS_CHANNEL, [(0, _helpers.createTaskMetric)(taskName, true, fetcher.startTime)]);
        return counter;
      } catch (err) {
        await sender.sendOnDemand(_constants.TASK_METRICS_CHANNEL, [(0, _helpers.createTaskMetric)(taskName, false, fetcher.startTime, err.message)]);
        return 0;
      }
    }
  };
}