"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._formatPrivileges = void 0;
exports.checkAndFormatPrivileges = checkAndFormatPrivileges;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupPrivilegesByName = privileges => {
  return privileges.reduce((acc, {
    privilege,
    authorized
  }) => {
    acc[privilege] = authorized;
    return acc;
  }, {});
};
const _formatPrivileges = privileges => {
  const clusterPrivilegesByPrivilege = groupPrivilegesByName(privileges.elasticsearch.cluster);
  const indexPrivilegesByIndex = Object.entries(privileges.elasticsearch.index).reduce((acc, [index, indexPrivileges]) => {
    acc[index] = groupPrivilegesByName(indexPrivileges);
    return acc;
  }, {});
  return {
    elasticsearch: {
      ...(Object.keys(indexPrivilegesByIndex).length > 0 ? {
        index: indexPrivilegesByIndex
      } : {}),
      ...(Object.keys(clusterPrivilegesByPrivilege).length > 0 ? {
        cluster: clusterPrivilegesByPrivilege
      } : {})
    }
  };
};
exports._formatPrivileges = _formatPrivileges;
async function checkAndFormatPrivileges({
  request,
  security,
  privilegesToCheck
}) {
  const checkPrivileges = security.authz.checkPrivilegesDynamicallyWithRequest(request);
  const {
    privileges,
    hasAllRequested
  } = await checkPrivileges(privilegesToCheck);
  return {
    privileges: _formatPrivileges(privileges),
    has_all_required: hasAllRequested
  };
}