"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskEngineEnableRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskEngineEnableRoute = (router, getStartServices) => {
  router.versioned.post({
    access: 'internal',
    path: _constants.RISK_ENGINE_ENABLE_URL,
    options: {
      tags: ['access:securitySolution', `access:${_constants.APP_ID}-entity-analytics`]
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const [_, {
      taskManager
    }] = await getStartServices();
    const securitySolution = await context.securitySolution;
    const riskEngineClient = securitySolution.getRiskEngineDataClient();
    if (!taskManager) {
      return siemResponse.error({
        statusCode: 400,
        body: _translations.TASK_MANAGER_UNAVAILABLE_ERROR
      });
    }
    try {
      await riskEngineClient.enableRiskEngine({
        taskManager
      });
      return response.ok({
        body: {
          success: true
        }
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.riskEngineEnableRoute = riskEngineEnableRoute;