"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserRiskEnginePrivileges = void 0;
var _risk_engine = require("../../../../common/risk_engine");
var _check_and_format_privileges = require("../utils/check_and_format_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUserRiskEnginePrivileges = async (request, security) => {
  return (0, _check_and_format_privileges.checkAndFormatPrivileges)({
    request,
    security,
    privilegesToCheck: {
      elasticsearch: {
        cluster: _risk_engine.RISK_ENGINE_REQUIRED_ES_CLUSTER_PRIVILEGES,
        index: _risk_engine.RISK_ENGINE_REQUIRED_ES_INDEX_PRIVILEGES
      }
    }
  });
};
exports.getUserRiskEnginePrivileges = getUserRiskEnginePrivileges;