"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetCriticalityPrivilegesRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _check_and_init_asset_criticality_resources = require("../check_and_init_asset_criticality_resources");
var _get_user_asset_criticality_privileges = require("../get_user_asset_criticality_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetCriticalityPrivilegesRoute = (router, getStartServices, logger) => {
  router.versioned.get({
    access: 'internal',
    path: _constants.ASSET_CRITICALITY_PRIVILEGES_URL,
    options: {
      tags: ['access:securitySolution', `access:${_constants.APP_ID}-entity-analytics`]
    }
  }).addVersion({
    version: '1',
    validate: false
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
      const [_, {
        security
      }] = await getStartServices();
      const body = await (0, _get_user_asset_criticality_privileges.getUserAssetCriticalityPrivileges)(request, security);
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.assetCriticalityPrivilegesRoute = assetCriticalityPrivilegesRoute;