"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEsqlAlertType = void 0;
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../../../../common/constants");
var _rule_schema = require("../../rule_schema");
var _esql = require("./esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEsqlAlertType = createOptions => {
  const {
    version
  } = createOptions;
  return {
    id: _securitysolutionRules.ESQL_RULE_TYPE_ID,
    name: 'ES|QL Rule',
    validate: {
      params: {
        validate: object => {
          return _rule_schema.EsqlRuleParams.parse(object);
        }
      }
    },
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    defaultActionGroupId: 'default',
    actionVariables: {
      context: [{
        name: 'server',
        description: 'the server'
      }]
    },
    minimumLicenseRequired: 'basic',
    isExportable: false,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    producer: _constants.SERVER_APP_ID,
    executor: params => (0, _esql.esqlExecutor)({
      ...params,
      version
    })
  };
};
exports.createEsqlAlertType = createEsqlAlertType;