"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleExecutionSummary = void 0;
var _rule_monitoring = require("../../../../../../common/api/detection_engine/rule_monitoring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRuleExecutionSummary = rule => {
  var _lastRunPublic$outcom, _lastRunPublic$outcom2, _lastRunInternal$metr, _lastRunInternal$metr2, _lastRunInternal$metr3;
  if (!rule.monitoring) {
    // In the rule type the monitoring object is optional because in some cases rules client returns a rule without it.
    // For instance, when we call RulesClient.create(). Despite the fact that it's always in the rule saved object,
    // even when it was just created:
    // https://github.com/elastic/kibana/blob/26eddec70844ffb65e5d3521a7adb52e643c4534/x-pack/plugins/alerting/server/rules_client/methods/create.ts#L155
    return null;
  }

  // Data that we need to create rule execution summary is stored in two different "last run" objects within a rule.

  // This last run object is internal to Kibana server and is not exposed via any public HTTP API.
  // Alerting Framework keeps it for itself and provides via the RulesClient for solutions.
  const lastRunInternal = rule.monitoring.run.last_run;
  // This last run object is public - it is exposed via the public Alerting HTTP API.
  const lastRunPublic = rule.lastRun;
  if (rule.running) {
    return {
      last_execution: {
        date: lastRunInternal.timestamp,
        status: _rule_monitoring.RuleExecutionStatusEnum.running,
        status_order: (0, _rule_monitoring.ruleExecutionStatusToNumber)(_rule_monitoring.RuleExecutionStatusEnum.running),
        message: '',
        metrics: {}
      }
    };
  }
  if (!lastRunPublic) {
    return null;
  }
  const ruleExecutionStatus = (0, _rule_monitoring.ruleLastRunOutcomeToExecutionStatus)(lastRunPublic.outcome);
  return {
    last_execution: {
      date: lastRunInternal.timestamp,
      status: ruleExecutionStatus,
      status_order: (0, _rule_monitoring.ruleExecutionStatusToNumber)(ruleExecutionStatus),
      message: (_lastRunPublic$outcom = (_lastRunPublic$outcom2 = lastRunPublic.outcomeMsg) === null || _lastRunPublic$outcom2 === void 0 ? void 0 : _lastRunPublic$outcom2.join(' \n')) !== null && _lastRunPublic$outcom !== void 0 ? _lastRunPublic$outcom : '',
      metrics: {
        total_indexing_duration_ms: (_lastRunInternal$metr = lastRunInternal.metrics.total_indexing_duration_ms) !== null && _lastRunInternal$metr !== void 0 ? _lastRunInternal$metr : undefined,
        total_search_duration_ms: (_lastRunInternal$metr2 = lastRunInternal.metrics.total_search_duration_ms) !== null && _lastRunInternal$metr2 !== void 0 ? _lastRunInternal$metr2 : undefined,
        execution_gap_duration_s: (_lastRunInternal$metr3 = lastRunInternal.metrics.gap_duration_s) !== null && _lastRunInternal$metr3 !== void 0 ? _lastRunInternal$metr3 : undefined
      }
    }
  };
};
exports.createRuleExecutionSummary = createRuleExecutionSummary;