"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_KQL_TOOLTIP = exports.SEARCH_KQL_SELECTED_TEXT = exports.SEARCH_KQL_PLACEHOLDER = exports.SEARCH_DESCRIPTION = exports.FILTER_KQL_TOOLTIP = exports.FILTER_KQL_SELECTED_TEXT = exports.FILTER_KQL_PLACEHOLDER = exports.FILTER_DESCRIPTION = exports.ERROR_PROCESSING_INDEX_PATTERNS = exports.DATA_PROVIDER_VISIBLE = exports.DATA_PROVIDER_HIDDEN_POPULATED = exports.DATA_PROVIDER_HIDDEN_EMPTY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterDescription', {
  defaultMessage: 'Events from the data providers above are filtered by the adjacent KQL'
});
exports.FILTER_DESCRIPTION = FILTER_DESCRIPTION;
const FILTER_KQL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlTooltip', {
  defaultMessage: 'Events from the data providers above are filtered by this KQL'
});
exports.FILTER_KQL_TOOLTIP = FILTER_KQL_TOOLTIP;
const FILTER_KQL_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlPlaceholder', {
  defaultMessage: 'Filter events'
});
exports.FILTER_KQL_PLACEHOLDER = FILTER_KQL_PLACEHOLDER;
const FILTER_KQL_SELECTED_TEXT = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlSelectedText', {
  defaultMessage: 'Filter'
});
exports.FILTER_KQL_SELECTED_TEXT = FILTER_KQL_SELECTED_TEXT;
const SEARCH_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchDescription', {
  defaultMessage: 'Events from the data providers above are combined with results from the adjacent KQL'
});
exports.SEARCH_DESCRIPTION = SEARCH_DESCRIPTION;
const SEARCH_KQL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlTooltip', {
  defaultMessage: 'Events from the data providers above are combined with results from this KQL'
});
exports.SEARCH_KQL_TOOLTIP = SEARCH_KQL_TOOLTIP;
const SEARCH_KQL_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlPlaceholder', {
  defaultMessage: 'Search events'
});
exports.SEARCH_KQL_PLACEHOLDER = SEARCH_KQL_PLACEHOLDER;
const SEARCH_KQL_SELECTED_TEXT = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlSelectedText', {
  defaultMessage: 'Search'
});
exports.SEARCH_KQL_SELECTED_TEXT = SEARCH_KQL_SELECTED_TEXT;
const DATA_PROVIDER_HIDDEN_POPULATED = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.dataProviderToggle.hiddenAndPopulated', {
  defaultMessage: 'Click to access the query in the query builder'
});
exports.DATA_PROVIDER_HIDDEN_POPULATED = DATA_PROVIDER_HIDDEN_POPULATED;
const DATA_PROVIDER_VISIBLE = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.dataProviderToggle.visible', {
  defaultMessage: 'Click to collapse the query builder'
});
exports.DATA_PROVIDER_VISIBLE = DATA_PROVIDER_VISIBLE;
const DATA_PROVIDER_HIDDEN_EMPTY = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.dataProviderToggle.hiddenAndEmpty', {
  defaultMessage: 'Click to expand the empty query builder'
});
exports.DATA_PROVIDER_HIDDEN_EMPTY = DATA_PROVIDER_HIDDEN_EMPTY;
const ERROR_PROCESSING_INDEX_PATTERNS = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.errorProcessingDataView', {
  defaultMessage: 'Error processing Index Patterns'
});
exports.ERROR_PROCESSING_INDEX_PATTERNS = ERROR_PROCESSING_INDEX_PATTERNS;