"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../store/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _graph_overlay = require("../../graph_overlay");
var _use_session_view = require("../session_tab_content/use_session_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScrollableFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  ${({
  theme
}) => `margin: 0 ${theme.eui.euiSizeM};`}
  overflow: hidden;
`;
const VerticalRule = _styledComponents.default.div`
  width: 2px;
  height: 100%;
  background: ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
const GraphTabContentComponent = ({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const graphEventId = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, timelineId)) === null || _getTimeline === void 0 ? void 0 : _getTimeline.graphEventId;
  });
  const {
    Navigation
  } = (0, _use_session_view.useSessionViewNavigation)({
    scopeId: timelineId
  });
  const {
    shouldShowDetailsPanel,
    DetailsPanel,
    SessionView
  } = (0, _use_session_view.useSessionView)({
    scopeId: timelineId
  });
  if (!graphEventId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_graph_overlay.GraphOverlay, {
    scopeId: timelineId,
    Navigation: Navigation,
    SessionView: SessionView
  }), shouldShowDetailsPanel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(VerticalRule, null), /*#__PURE__*/_react.default.createElement(ScrollableFlexItem, {
    grow: 1
  }, DetailsPanel)));
};
GraphTabContentComponent.displayName = 'GraphTabContentComponent';
const GraphTabContent = /*#__PURE__*/_react.default.memo(GraphTabContentComponent);

// eslint-disable-next-line import/no-default-export
exports.default = GraphTabContent;
module.exports = exports.default;