"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultCellRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _data_driven_columns = require("../body/data_driven_columns");
var _renderers = require("../body/renderers");
var _get_column_renderer = require("../body/renderers/get_column_renderer");
var _helpers = require("../../../../common/lib/cell_actions/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledContent = _styledComponents.default.div`
  padding: ${({
  $isDetails
}) => $isDetails ? '0 8px' : undefined};
  width: 100%;
  margin: 0 auto;
`;
const DefaultCellRenderer = ({
  data,
  ecsData,
  eventId,
  header,
  isDetails,
  isDraggable,
  isTimeline,
  linkValues,
  rowRenderers,
  scopeId,
  truncate,
  asPlainText,
  context
}) => {
  const asPlainTextDefault = (0, _react.useMemo)(() => {
    return (0, _helpers.getLinkColumnDefinition)(header.id, header.type, header.linkField) !== undefined && !isTimeline;
  }, [header.id, header.linkField, header.type, isTimeline]);
  const values = (0, _data_driven_columns.useGetMappedNonEcsValue)({
    data,
    fieldName: header.id
  });
  const styledContentClassName = isDetails ? 'eui-textBreakWord' : 'eui-displayInlineBlock eui-textTruncate';
  return /*#__PURE__*/_react.default.createElement(StyledContent, {
    className: styledContentClassName,
    $isDetails: isDetails
  }, (0, _get_column_renderer.getColumnRenderer)(header.id, _renderers.columnRenderers, data, context).renderColumn({
    asPlainText: asPlainText !== null && asPlainText !== void 0 ? asPlainText : asPlainTextDefault,
    // we want to render value with links as plain text but keep other formatters like badge. Except rule name for non preview tables
    columnName: header.id,
    ecsData,
    eventId,
    field: header,
    isDetails,
    isDraggable,
    linkValues,
    rowRenderers,
    scopeId,
    truncate,
    values,
    context
  }));
};
exports.DefaultCellRenderer = DefaultCellRenderer;