"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventSummaryColumnRenderer = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("./constants");
var _get_row_renderer = require("./get_row_renderer");
var _plain_column_renderer = require("./plain_column_renderer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventRenderedFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  div:first-child {
    padding-left: 0px;
    div {
      margin: 0px;
    }
  }
`;
const eventSummaryColumnRenderer = {
  isInstance: (0, _fp.isEqual)(_constants.EVENT_SUMMARY_FIELD_NAME),
  renderColumn: ({
    ecsData,
    columnName,
    eventId,
    field,
    isDetails,
    linkValues,
    rowRenderers = [],
    scopeId,
    truncate,
    values
  }) => {
    if (ecsData && rowRenderers) {
      return /*#__PURE__*/_react.default.createElement(SummaryCell, {
        ecsData: ecsData,
        key: `reason-column-renderer-value-${scopeId}-${columnName}-${eventId}-${field.id}`,
        rowRenderers: rowRenderers,
        scopeId: scopeId,
        values: values
      });
    } else {
      return _plain_column_renderer.plainColumnRenderer.renderColumn({
        columnName,
        eventId,
        field,
        isDetails,
        isDraggable: false,
        linkValues,
        scopeId,
        truncate,
        values
      });
    }
  }
};
exports.eventSummaryColumnRenderer = eventSummaryColumnRenderer;
const SummaryCell = ({
  ecsData,
  rowRenderers,
  scopeId,
  values
}) => {
  const rowRenderer = (0, _react.useMemo)(() => (0, _get_row_renderer.getRowRenderer)({
    data: ecsData,
    rowRenderers
  }), [ecsData, rowRenderers]);
  const rowRender = (0, _react.useMemo)(() => {
    return rowRenderer && rowRenderer.renderRow({
      data: ecsData,
      isDraggable: false,
      scopeId
    });
  }, [rowRenderer, ecsData, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    className: "eui-fullWidth"
  }, rowRenderer && rowRender ? /*#__PURE__*/_react.default.createElement(EventRenderedFlexItem, {
    className: "eui-xScroll"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-displayInlineBlock",
    style: {
      width: 'fit-content'
    }
  }, rowRender)) : values && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "plain-text-reason"
  }, values));
};