"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndgameSecurityEventDetailsLine = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../helpers");
var _process_draggable = require("../process_draggable");
var _user_host_working_dir = require("../user_host_working_dir");
var _helpers2 = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndgameSecurityEventDetailsLine = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgameLogonType,
  endgameSubjectDomainName,
  endgameSubjectLogonId,
  endgameSubjectUserName,
  endgameTargetDomainName,
  endgameTargetLogonId,
  endgameTargetUserName,
  eventAction,
  eventCode,
  eventOutcome,
  hostName,
  id,
  isDraggable,
  processExecutable,
  processName,
  processPid,
  userDomain,
  userName,
  winlogEventId
}) => {
  const domain = (0, _helpers2.getTargetUserAndTargetDomain)(eventAction) ? endgameTargetDomainName : userDomain;
  const eventDetails = (0, _helpers2.getEventDetails)({
    eventAction,
    eventOutcome
  });
  const hostNameSeparator = (0, _helpers2.getHostNameSeparator)(eventAction);
  const user = (0, _helpers2.getTargetUserAndTargetDomain)(eventAction) ? endgameTargetUserName : userName;
  const userDomainField = (0, _helpers2.getUserDomainField)(eventAction);
  const userNameField = (0, _helpers2.getUserNameField)(eventAction);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "none",
    wrap: true
  }, eventAction === 'admin_logon' && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "with-special-privileges",
    grow: false
  }, i18n.WITH_SPECIAL_PRIVILEGES), eventAction === 'explicit_user_logon' && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "a-login-was-attempted",
    grow: false
  }, i18n.A_LOGIN_WAS_ATTEMPTED_USING_EXPLICIT_CREDENTIALS), /*#__PURE__*/_react.default.createElement(_user_host_working_dir.UserHostWorkingDir, {
    contextId: contextId,
    eventId: id,
    hostName: hostName,
    hostNameSeparator: hostNameSeparator,
    isDraggable: isDraggable,
    userDomain: domain,
    userDomainField: userDomainField,
    userName: user,
    userNameField: userNameField,
    workingDirectory: undefined
  }), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "event-details",
    grow: false
  }, eventDetails), !(0, _helpers.isNillEmptyOrNotFinite)(endgameLogonType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "using-logon-type",
    grow: false
  }, i18n.USING_LOGON_TYPE), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "endgame.logon_type",
    isDraggable: isDraggable,
    queryValue: String(endgameLogonType),
    value: `${endgameLogonType} - ${(0, _helpers2.getHumanReadableLogonType)(endgameLogonType)}`,
    isAggregatable: true,
    fieldType: "keyword"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(endgameTargetLogonId) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, '('), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "using-logon-type",
    grow: false
  }, i18n.TARGET_LOGON_ID), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "endgame.target_logon_id",
    isDraggable: isDraggable,
    value: endgameTargetLogonId,
    isAggregatable: true,
    fieldType: "keyword"
  })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, ')')), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, i18n.VIA), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggableWithNonExistentProcess, {
    contextId: contextId,
    endgamePid: undefined,
    endgameProcessName: undefined,
    eventId: id,
    isDraggable: isDraggable,
    processPid: processPid,
    processName: processName,
    processExecutable: processExecutable
  })), !(0, _helpers.isNillEmptyOrNotFinite)(endgameSubjectUserName) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "as-requested-by-subject",
    grow: false
  }, i18n.AS_REQUESTED_BY_SUBJECT), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "endgame.subject_user_name",
    isDraggable: isDraggable,
    iconType: "user",
    value: endgameSubjectUserName,
    isAggregatable: true,
    fieldType: "keyword"
  }))), endgameSubjectDomainName != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "subject-domain-name-domain-separator-text",
    grow: false
  }, '\\'), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "endgame.subject_domain_name",
    isDraggable: isDraggable,
    value: endgameSubjectDomainName,
    isAggregatable: true,
    fieldType: "keyword"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(endgameSubjectLogonId) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, '('), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "subject-login-id",
    grow: false
  }, i18n.SUBJECT_LOGON_ID), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "endgame.subject_logon_id",
    isDraggable: isDraggable,
    value: endgameSubjectLogonId,
    isAggregatable: true,
    fieldType: "keyword"
  })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, ')')), (!(0, _helpers.isNillEmptyOrNotFinite)(eventCode) || !(0, _helpers.isNillEmptyOrNotFinite)(winlogEventId)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(eventCode) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "event.code",
    value: eventCode,
    isAggregatable: true,
    fieldType: "keyword"
  })) : /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    iconType: "logoWindows",
    field: "winlog.event_id",
    value: winlogEventId,
    isAggregatable: true,
    fieldType: "keyword"
  })))));
});
exports.EndgameSecurityEventDetailsLine = EndgameSecurityEventDetailsLine;
EndgameSecurityEventDetailsLine.displayName = 'EndgameSecurityEventDetailsLine';