"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DnsRequestEventDetailsLine = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../helpers");
var _process_draggable = require("../process_draggable");
var _user_host_working_dir = require("../user_host_working_dir");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DnsRequestEventDetailsLine = /*#__PURE__*/_react.default.memo(({
  contextId,
  dnsQuestionName,
  dnsQuestionType,
  dnsResolvedIp,
  dnsResponseCode,
  eventCode,
  hostName,
  id,
  isDraggable,
  processExecutable,
  processName,
  processPid,
  userDomain,
  userName,
  winlogEventId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "none",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_user_host_working_dir.UserHostWorkingDir, {
    contextId: contextId,
    eventId: id,
    hostName: hostName,
    isDraggable: isDraggable,
    userDomain: userDomain,
    userName: userName,
    workingDirectory: undefined
  }), !(0, _helpers.isNillEmptyOrNotFinite)(dnsQuestionName) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "asked-for",
    grow: false
  }, i18n.ASKED_FOR), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "dns.question.name",
    isDraggable: isDraggable,
    value: dnsQuestionName,
    isAggregatable: true,
    fieldType: "keyword"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsQuestionType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "with-question-type",
    grow: false
  }, i18n.WITH_QUESTION_TYPE), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "dns.question.type",
    isDraggable: isDraggable,
    value: dnsQuestionType,
    isAggregatable: true,
    fieldType: "keyword"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsResolvedIp) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "which-resolved-to",
    grow: false
  }, i18n.WHICH_RESOLVED_TO), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "dns.resolved_ip",
    isDraggable: isDraggable,
    value: dnsResolvedIp,
    isAggregatable: true,
    fieldType: "ip"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsResponseCode) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, '('), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "response-code",
    grow: false
  }, i18n.RESPONSE_CODE), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "dns.response_code",
    isDraggable: isDraggable,
    value: dnsResponseCode,
    isAggregatable: true,
    fieldType: "keyword"
  })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, ')')), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, i18n.VIA), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggableWithNonExistentProcess, {
    contextId: contextId,
    endgamePid: undefined,
    endgameProcessName: undefined,
    eventId: id,
    isDraggable: isDraggable,
    processPid: processPid,
    processName: processName,
    processExecutable: processExecutable
  })), (!(0, _helpers.isNillEmptyOrNotFinite)(eventCode) || !(0, _helpers.isNillEmptyOrNotFinite)(winlogEventId)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(eventCode) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "event.code",
    isDraggable: isDraggable,
    value: eventCode,
    isAggregatable: true,
    fieldType: "number"
  })) : /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    iconType: "logoWindows",
    field: "winlog.event_id",
    isDraggable: isDraggable,
    value: winlogEventId,
    isAggregatable: true,
    fieldType: "keyword"
  })))));
});
exports.DnsRequestEventDetailsLine = DnsRequestEventDetailsLine;
DnsRequestEventDetailsLine.displayName = 'DnsRequestEventDetailsLine';