"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventsSelectOptions = exports.DropdownDisplay = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _pin = require("../../../pin");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InputDisplay = _styledComponents.default.div`
  width: 5px;
`;
InputDisplay.displayName = 'InputDisplay';
const PinIconContainer = _styledComponents.default.div`
  margin-right: 5px;
`;
PinIconContainer.displayName = 'PinIconContainer';
const PinActionItem = _styledComponents.default.div`
  display: flex;
  flex-direction: row;
`;
PinActionItem.displayName = 'PinActionItem';
const DropdownDisplay = /*#__PURE__*/_react.default.memo(({
  text
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  color: "subdued"
}, text));
exports.DropdownDisplay = DropdownDisplay;
DropdownDisplay.displayName = 'DropdownDisplay';
const getEventsSelectOptions = () => [{
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.SELECT_ALL
  }),
  value: 'select-all'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.SELECT_NONE
  }),
  value: 'select-none'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.SELECT_PINNED
  }),
  value: 'select-pinned'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.SELECT_UNPINNED
  }),
  value: 'select-unpinned'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(PinActionItem, null, /*#__PURE__*/_react.default.createElement(PinIconContainer, null, /*#__PURE__*/_react.default.createElement(_pin.Pin, {
    allowUnpinning: true,
    isAlert: false,
    pinned: true
  })), /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.PIN_SELECTED
  })),
  value: 'pin-selected'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(PinActionItem, null, /*#__PURE__*/_react.default.createElement(PinIconContainer, null, /*#__PURE__*/_react.default.createElement(_pin.Pin, {
    allowUnpinning: true,
    isAlert: false,
    pinned: false
  })), /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.UNPIN_SELECTED
  })),
  value: 'unpin-selected'
}];
exports.getEventsSelectOptions = getEventsSelectOptions;