"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedUserItems = void 0;
var _react = require("react");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useObservedUserItems = userData => (0, _react.useMemo)(() => {
  var _userData$details$use, _userData$details$use2, _userData$details$hos, _userData$details$hos2, _userData$details$hos3, _userData$details$hos4, _userData$details$hos5;
  return !userData.details ? [] : [{
    label: i18n.USER_ID,
    values: (_userData$details$use = userData.details.user) === null || _userData$details$use === void 0 ? void 0 : _userData$details$use.id,
    field: 'user.id'
  }, {
    label: 'Domain',
    values: (_userData$details$use2 = userData.details.user) === null || _userData$details$use2 === void 0 ? void 0 : _userData$details$use2.domain,
    field: 'user.domain'
  }, {
    label: i18n.MAX_ANOMALY_SCORE_BY_JOB,
    field: 'anomalies',
    values: userData.anomalies
  }, {
    label: i18n.FIRST_SEEN,
    values: userData.firstSeen.date ? [userData.firstSeen.date] : undefined,
    field: '@timestamp'
  }, {
    label: i18n.LAST_SEEN,
    values: userData.lastSeen.date ? [userData.lastSeen.date] : undefined,
    field: '@timestamp'
  }, {
    label: i18n.OPERATING_SYSTEM_TITLE,
    values: (_userData$details$hos = userData.details.host) === null || _userData$details$hos === void 0 ? void 0 : (_userData$details$hos2 = _userData$details$hos.os) === null || _userData$details$hos2 === void 0 ? void 0 : _userData$details$hos2.name,
    field: 'host.os.name'
  }, {
    label: i18n.FAMILY,
    values: (_userData$details$hos3 = userData.details.host) === null || _userData$details$hos3 === void 0 ? void 0 : (_userData$details$hos4 = _userData$details$hos3.os) === null || _userData$details$hos4 === void 0 ? void 0 : _userData$details$hos4.family,
    field: 'host.os.family'
  }, {
    label: i18n.IP_ADDRESSES,
    values: (_userData$details$hos5 = userData.details.host) === null || _userData$details$hos5 === void 0 ? void 0 : _userData$details$hos5.ip,
    field: 'host.ip'
  }];
}, [userData.details, userData.anomalies, userData.firstSeen, userData.lastSeen]);
exports.useObservedUserItems = useObservedUserItems;