"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedUser = void 0;
var _react = require("react");
var _observed_details = require("../../../../../explore/users/containers/users/observed_details");
var _search_strategy = require("../../../../../../common/search_strategy");
var _sourcerer = require("../../../../../common/containers/sourcerer");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _use_first_last_seen = require("../../../../../common/containers/use_first_last_seen");
var _manage_query = require("../../../../../common/components/page/manage_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useObservedUser = userName => {
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const {
    to,
    from,
    isInitializing,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const [loadingObservedUser, {
    userDetails: observedUserDetails,
    inspect,
    refetch,
    id: queryId
  }] = (0, _observed_details.useObservedUserDetails)({
    endDate: to,
    startDate: from,
    userName,
    indexNames: selectedPatterns,
    skip: isInitializing
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId,
    loading: loadingObservedUser
  });
  const [loadingFirstSeen, {
    firstSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'user.name',
    value: userName,
    defaultIndex: selectedPatterns,
    order: _search_strategy.Direction.asc,
    filterQuery: _search_strategy.NOT_EVENT_KIND_ASSET_FILTER
  });
  const [loadingLastSeen, {
    lastSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'user.name',
    value: userName,
    defaultIndex: selectedPatterns,
    order: _search_strategy.Direction.desc,
    filterQuery: _search_strategy.NOT_EVENT_KIND_ASSET_FILTER
  });
  return (0, _react.useMemo)(() => ({
    details: observedUserDetails,
    isLoading: loadingObservedUser,
    firstSeen: {
      date: firstSeen,
      isLoading: loadingFirstSeen
    },
    lastSeen: {
      date: lastSeen,
      isLoading: loadingLastSeen
    }
  }), [firstSeen, lastSeen, loadingFirstSeen, loadingLastSeen, loadingObservedUser, observedUserDetails]);
};
exports.useObservedUser = useObservedUser;